package com.biz.crm.tpm.business.vertical.form.table.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.vertical.form.table.local.dto.UpdateQuantityWarnDto;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.PriceMonitorFormEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.mapper.PriceMonitorFormMapper;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.PriceMonitorFormWarningQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 垂直退转曾报表(PriceMonitorFormRepository)数据库访问层
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@Component
public class PriceMonitorFormRepository extends ServiceImpl<PriceMonitorFormMapper, PriceMonitorFormEntity> {

    public List<PriceMonitorFormEntity> findByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)){
            return Lists.newArrayList();
        }else {
            return this.lambdaQuery().in(PriceMonitorFormEntity::getOnlyKey,onlyKeys)
                    .eq(PriceMonitorFormEntity::getTenantCode, TenantUtils.getTenantCode())
                    .select(PriceMonitorFormEntity::getId,PriceMonitorFormEntity::getOnlyKey)
                    .eq(PriceMonitorFormEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
        }
    }

    public List<Map<String, Object>> findPriceMonitorFormWarning(PriceMonitorFormWarningQueryDto dto) {
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setYearAndMonth(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH));
        return this.baseMapper.findPriceMonitorFormWarning(dto);
    }

    public void updateQuantityWarn(UpdateQuantityWarnDto dto) {
        this.lambdaUpdate()
                .set(PriceMonitorFormEntity::getQuantityWarn,dto.getQuantityWarn())
                .eq(PriceMonitorFormEntity::getId,dto.getId())
                .update();
    }
}
