package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.returns.order.sdk.dto.ReturnOrderDto;
import com.biz.crm.kms.business.invoice.returns.order.sdk.service.ReturnOrderVoService;
import com.biz.crm.kms.business.invoice.returns.order.sdk.vo.TpmReturnOrderVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.ActivityReturnTransGiftEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.ActivityReturnTransGiftRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.ActivityReturnTransGiftService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 垂直退转赠报表(ActivityReturnTransGift)服务实现类
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
@Slf4j
@Service("ActivityReturnTransGiftService")
public class ActivityReturnTransGiftServiceImpl implements ActivityReturnTransGiftService {

    /**
     * 活动形式退转赠
     */
    private final static String RETURNTRANSGIFT = "HDXS2023011100035";

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private ReturnOrderVoService returnOrderVoService;

    @Autowired(required = false)
    private ActivityReturnTransGiftRepository activityReturnTransGiftRepository;


    /**
     * //1、维度：零售商+区域+门店+产品+年月
     * //2、取退货数据时需过滤掉空退的数据（退货类型为“退转赠”或为空）
     * //3、再汇总到零售商+区域维度
     * //4、监控当月的退转赠
     *
     * @param codes
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createOrUpdateData(List<String> codes) {
        ActivityDetailPlanItemDto queryDto = new ActivityDetailPlanItemDto();
        if (CollectionUtil.isEmpty(codes)) {
            queryDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            queryDto.setActivityYearMonth(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH));
            queryDto.setActivityFormCode(RETURNTRANSGIFT);
        } else {
            queryDto.setDetailPlanItemCodeList(codes);
        }

        Pageable pageable = PageRequest.of(1, 2000);
        queryDto.setActivityFormCode(RETURNTRANSGIFT);
        Page<ActivityDetailPlanItemVo> byConditions = this.activityDetailPlanItemSdkService.findByConditions(pageable, queryDto);
        List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList = new ArrayList<>();
        activityDetailPlanItemVoList.addAll(byConditions.getRecords());
        while (byConditions.hasNext()) {
            pageable = pageable.next();
            byConditions = this.activityDetailPlanItemSdkService.findByConditions(pageable, queryDto);
            activityDetailPlanItemVoList.addAll(byConditions.getRecords());
        }
        if (CollectionUtil.isEmpty(activityDetailPlanItemVoList)) {
            return;
        }
        log.info("本次更新数据量{}", activityDetailPlanItemVoList.size());
        //1、维度：零售商+区域+门店+产品+年月
        Map<String, List<ActivityDetailPlanItemVo>> groupPlanItemMap = activityDetailPlanItemVoList.stream().filter(vo -> StringUtils.isNotEmpty(vo.getSystemCode())
                        && StringUtils.isNotEmpty(vo.getRegion())
                        && StringUtils.isNotEmpty(vo.getTerminalCode())
                        && StringUtils.isNotEmpty(vo.getProductCode()))
                .collect(Collectors.groupingBy(vo -> StringUtils.joinWith("-", vo.getSystemCode(), vo.getRegion(), vo.getTerminalCode(), vo.getProductCode(), DateUtil.format(vo.getActivityBeginDate(), DateUtil.DEFAULT_YEAR_MONTH))));

        //2、取退货数据时需过滤掉空退的数据（退货类型为“退转赠”或为空）
        ReturnOrderDto dto = new ReturnOrderDto();
        List<String> terminalCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getTerminalCode).distinct().collect(Collectors.toList());
        List<String> productCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getProductCode).distinct().collect(Collectors.toList());
        List<String> tpmSystemCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getSystemCode).distinct().collect(Collectors.toList());
        List<String> regions = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getRegion).distinct().collect(Collectors.toList());
        dto.setTerminalCodeList(terminalCodes);
        dto.setProductCodeList(productCodes);
        dto.setCustomerRetailerCodeList(tpmSystemCodes);
        dto.setAreaCodes(regions);
        List<TpmReturnOrderVo> tpmReturnOrderVos = this.returnOrderVoService.tpmFindReturnGoodsByConditions(dto);
        log.info("TPM查询KMS退货单数据量{}", tpmReturnOrderVos.size());
        Map<String, List<TpmReturnOrderVo>> returnMap = new HashMap<>();
        if (!CollectionUtil.isEmpty(tpmReturnOrderVos)) {
            returnMap = tpmReturnOrderVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith("-", vo.getTpmSystemCode(), vo.getBusinessArea(), vo.getDeliveryPartyCode(), vo.getProductCode(), DateUtil.format(vo.getOrderTime(), DateUtil.DEFAULT_YEAR_MONTH))));
        }

        //3、
        Calendar calendar = Calendar.getInstance();
        Date startDay = DateUtil.getFirstDayOfMonth(new Date());
        calendar.setTime(startDay);
        //1-7号
        calendar.add(Calendar.DATE, 7);
        Date oneDay = calendar.getTime();
        //8-14号
        calendar.add(Calendar.DATE, 7);
        Date twoDay = calendar.getTime();
        //15-21号
        calendar.add(Calendar.DATE, 7);
        Date threeDay = calendar.getTime();
        //22-31号
        Date fourDay = DateUtil.getLastDayOfMonth(new Date());
        List<ActivityReturnTransGiftEntity> entityList = new ArrayList<>();
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        for (Map.Entry<String, List<ActivityDetailPlanItemVo>> item : groupPlanItemMap.entrySet()) {
            String key = item.getKey();
            List<ActivityDetailPlanItemVo> value = item.getValue();
            List<TpmReturnOrderVo> tpmReturnOrderList = returnMap.get(key);
            ActivityReturnTransGiftEntity entity = this.buildParam(key, value, tpmReturnOrderList, startDay, oneDay, twoDay, threeDay, fourDay,tenantCode,delFlag);
            entityList.add(entity);
        }
        //保存
        List<ActivityReturnTransGiftEntity> saveList = new ArrayList<>();
        List<ActivityReturnTransGiftEntity> updateList = new ArrayList<>();
        List<String> collect = entityList.stream().map(ActivityReturnTransGiftEntity::getOnlyKey).distinct().collect(Collectors.toList());
        List<ActivityReturnTransGiftEntity> byOnlyKey = this.activityReturnTransGiftRepository.findByOnlyKey(collect);
        if (!CollectionUtil.isEmpty(byOnlyKey)){
            Map<String, String> onlyKeyMap = byOnlyKey.stream().collect(Collectors.toMap(ActivityReturnTransGiftEntity::getOnlyKey, ActivityReturnTransGiftEntity::getId));
            for (ActivityReturnTransGiftEntity entity : entityList) {
                if (onlyKeyMap.containsKey(entity.getOnlyKey())){
                    String id = onlyKeyMap.get(entity.getOnlyKey());
                    entity.setId(id);
                    updateList.add(entity);
                }else {
                    saveList.add(entity);
                }
            }
        }else {
            saveList.addAll(entityList);
        }
        if (!CollectionUtil.isEmpty(saveList)){
            this.activityReturnTransGiftRepository.saveBatch(saveList);
        }
        if (!CollectionUtil.isEmpty(updateList)){
            this.activityReturnTransGiftRepository.updateBatchById(updateList);
        }
    }


    private ActivityReturnTransGiftEntity buildParam(String key, List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList, List<TpmReturnOrderVo> tpmReturnOrderVoList
            , Date startDay, Date oneDay, Date twoDay, Date threeDay, Date fourDay,String tenantCode,String delFlag) {
        ActivityReturnTransGiftEntity entity = new ActivityReturnTransGiftEntity();
        ActivityDetailPlanItemVo activityDetailPlanItemVo = activityDetailPlanItemVoList.get(0);
        entity.setOnlyKey(key);
        BigDecimal mountReturnAmount = BigDecimal.ZERO;
        BigDecimal monthReturnNum = BigDecimal.ZERO;
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal oneAmount = BigDecimal.ZERO;
        BigDecimal twoAmount = BigDecimal.ZERO;
        BigDecimal threeAmount = BigDecimal.ZERO;
        BigDecimal fourAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(tpmReturnOrderVoList)){
            for (TpmReturnOrderVo tpmReturnOrderVo : tpmReturnOrderVoList) {
                mountReturnAmount = mountReturnAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                monthReturnNum = monthReturnNum.add(Optional.ofNullable(tpmReturnOrderVo.getCurCompanyUnitOrderQuantity()).orElse(BigDecimal.ZERO).abs());
                if (startDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(oneDay) < 0) {
                    oneAmount = oneAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                } else if (oneDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(twoDay) < 0) {
                    twoAmount = twoAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                } else if (twoDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(threeDay) < 0) {
                    threeAmount = threeAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                } else if (threeDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(fourDay) <= 0) {
                    fourAmount = fourAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                }
            }
        }

        for (ActivityDetailPlanItemVo detailPlanItemVo : activityDetailPlanItemVoList) {
            applyAmount = applyAmount.add(Optional.ofNullable(detailPlanItemVo.getFeeAmount()).orElse(BigDecimal.ZERO).abs());
            if (Objects.nonNull(detailPlanItemVo.getPeriodPromotionalNumber())) {
                quantity = quantity.add(new BigDecimal(detailPlanItemVo.getPeriodPromotionalNumber()));
            }
        }
        entity.setYearAndMonth(DateUtil.format(activityDetailPlanItemVo.getActivityBeginDate(), DateUtil.DEFAULT_YEAR_MONTH));
        entity.setBusinessFormatCode(activityDetailPlanItemVo.getBusinessFormatCode());
        entity.setBusinessUnitCode(activityDetailPlanItemVo.getBusinessUnitCode());
        entity.setSystemCode(activityDetailPlanItemVo.getSystemCode());
        entity.setSystemName(activityDetailPlanItemVo.getSystemName());
        entity.setRegion(activityDetailPlanItemVo.getRegion());
        entity.setRegionName(activityDetailPlanItemVo.getRegionName());
        entity.setTerminalCode(activityDetailPlanItemVo.getTerminalCode());
        entity.setTerminalName(activityDetailPlanItemVo.getTerminalName());
        entity.setProductCode(activityDetailPlanItemVo.getProductCode());
        entity.setProductName(activityDetailPlanItemVo.getProductName());
        entity.setMonthReturnAmount(mountReturnAmount);
        entity.setMonthReturnNum(monthReturnNum);
        entity.setApplyAmount(applyAmount);
        entity.setQuantity(quantity);
        entity.setMonthDifferAmount(entity.getMonthReturnAmount().subtract(entity.getApplyAmount()));
        entity.setMonthDifferNum(entity.getMonthReturnNum().subtract(entity.getQuantity()));
        entity.setOneAmount(oneAmount);
        entity.setTwoAmount(twoAmount);
        entity.setThreeAmount(threeAmount);
        entity.setFourAmount(fourAmount);
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(delFlag);
        if (null != entity.getApplyAmount() && BigDecimal.ZERO.compareTo(entity.getApplyAmount()) != 0) {
            entity.setMonthAmountRate(entity.getMonthReturnAmount().divide(entity.getApplyAmount(), 6, BigDecimal.ROUND_HALF_UP));
        } else {
            entity.setMonthAmountRate(BigDecimal.ZERO);
        }
        return entity;
    }
}
