package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;


import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.BudgetUseFormEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.BudgetUseFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormAsyncService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 预算使用监控报表
 *
 * @author: cyj
 * @version: v1.0.0
 * @date: 2022.12.15 13:53
 */
@Slf4j
@Service
public class BudgetUseFormAsyncServiceImpl implements BudgetUseFormAsyncService {

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private BudgetUseFormRepository budgetUseFormRepository;

    @Autowired(required = false)
    private SalesGoalService salesGoalServicel;

    @Async
    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED, rollbackFor = Exception.class)
    public void saveData(List<String> keys, Map<String, List<MonthBudgetVo>> monthBudgetMap, String tenantCode, String delCode, Map<String, List<YearBudgetVo>> yearBudgetVoMap, String date) {
        List<BudgetUseFormEntity> budgetUseFormEntityList = new ArrayList<>();
        //月度逻辑处理
        for (String key : keys) {
            List<MonthBudgetVo> monthBudgetVoList = monthBudgetMap.get(key);
            Map<String, List<MonthBudgetVo>> monthItemBudgetMap = monthBudgetVoList.stream().collect(Collectors.groupingBy(vo -> StringUtils.join(vo.getYearMonthLy(),vo.getRegionCode(), vo.getSystemCode(), vo.getBudgetItemCode())));
            for (String s : monthItemBudgetMap.keySet()) {
                List<MonthBudgetVo> monthVo = monthItemBudgetMap.get(s);
                BudgetUseFormEntity budgetUseFormEntity = this.buildMonthParam(s, monthVo, tenantCode, delCode, date);
                budgetUseFormEntityList.add(budgetUseFormEntity);
            }
        }
        //年度逻辑处理
        if (!CollectionUtils.isEmpty(budgetUseFormEntityList)) {
            Map<String, List<BudgetUseFormEntity>> yearBudgetUseMap = budgetUseFormEntityList.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith(vo.getRegionCode(), vo.getSystemCode(), vo.getBudgetItemCode())));

            budgetUseFormEntityList.clear();
            for (Map.Entry<String, List<BudgetUseFormEntity>> key : yearBudgetUseMap.entrySet()) {
                List<BudgetUseFormEntity> value = key.getValue();
                List<BudgetUseFormEntity> budgetUseFormEntities = this.buildYearParam(value, yearBudgetVoMap, date);
                budgetUseFormEntityList.addAll(budgetUseFormEntities);
            }
        }
        //保存
        List<String> onlyKeys = budgetUseFormEntityList.stream().map(BudgetUseFormEntity::getOnlyKey).distinct().collect(Collectors.toList());
        List<BudgetUseFormEntity> budgetUseFormEntities = this.budgetUseFormRepository.findByOnlyKey(onlyKeys);
        List<BudgetUseFormEntity> updateList = new ArrayList<>();
        List<BudgetUseFormEntity> saveList = new ArrayList<>();
        if (CollectionUtils.isEmpty(budgetUseFormEntities)) {
            saveList.addAll(budgetUseFormEntityList);
        } else {
            Map<String, String> entityMap = budgetUseFormEntities.stream().collect(Collectors.toMap(BudgetUseFormEntity::getOnlyKey, BudgetUseFormEntity::getId, (a, b) -> a));
            for (BudgetUseFormEntity budgetUseFormEntity : budgetUseFormEntityList) {
                if (entityMap.containsKey(budgetUseFormEntity.getOnlyKey())) {
                    String id = entityMap.get(budgetUseFormEntity.getOnlyKey());
                    budgetUseFormEntity.setId(id);
                    updateList.add(budgetUseFormEntity);
                } else {
                    saveList.add(budgetUseFormEntity);
                }
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.budgetUseFormRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.budgetUseFormRepository.updateBatchById(updateList);
        }

    }

    /**
     * 月逻辑处理
     *
     * @param key
     * @param monthBudgetVoList
     * @return
     */
    private BudgetUseFormEntity buildMonthParam(String key, List<MonthBudgetVo> monthBudgetVoList, String tenantCode, String delCode, String date) {
        BudgetUseFormEntity budgetUseFormEntity = new BudgetUseFormEntity();
        MonthBudgetVo monthBudgetVo = monthBudgetVoList.get(0);
        //基础信息
        budgetUseFormEntity.setId(null);
        budgetUseFormEntity.setOnlyKey(key);
        budgetUseFormEntity.setYearAndMonth(monthBudgetVo.getYearMonthLy());
        budgetUseFormEntity.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
        budgetUseFormEntity.setBudgetItemName(monthBudgetVo.getBudgetItemName());
        budgetUseFormEntity.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
        budgetUseFormEntity.setRegionCode(monthBudgetVo.getRegionCode());
        budgetUseFormEntity.setRegionName(monthBudgetVo.getRegionName());
        budgetUseFormEntity.setSystemCode(monthBudgetVo.getSystemCode());
        budgetUseFormEntity.setSystemName(monthBudgetVo.getSystemName());
        budgetUseFormEntity.setBusinessFormatCode(monthBudgetVo.getBusinessFormatCode());
        budgetUseFormEntity.setBusinessUnitCode(monthBudgetVo.getBusinessUnitCode());
        budgetUseFormEntity.setTenantCode(tenantCode);
        budgetUseFormEntity.setDelFlag(delCode);
        BigDecimal monthBudgetAmount = BigDecimal.ZERO;
        SalesPerformanceDto salesPerformanceDto = new SalesPerformanceDto();
        salesPerformanceDto.setRegion(monthBudgetVo.getRegionName());
        salesPerformanceDto.setRetailer(monthBudgetVo.getSystemName());
        salesPerformanceDto.setSalesDate(monthBudgetVo.getYearMonthLy());
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        salesPlanDto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
        salesPlanDto.setRegionCode(monthBudgetVo.getRegionCode());
        salesPlanDto.setSystemCode(monthBudgetVo.getSystemCode());

        //实际销额
        budgetUseFormEntity.setAcSaleAmount(Optional.ofNullable(this.salesPerformanceVoService.findSalesAmount(salesPerformanceDto)).orElse(BigDecimal.ZERO));

        //计划销额
        budgetUseFormEntity.setPlanSaleAmount(Optional.ofNullable(this.salesPlanService.findSaleAmount(salesPlanDto)).orElse(BigDecimal.ZERO));

        //已使用金额 = 批复金额+预估超额-批复结案差
        BigDecimal monthUseAmount = BigDecimal.ZERO;

        for (MonthBudgetVo budgetVo : monthBudgetVoList) {
            //当月预算金额
            monthBudgetAmount = monthBudgetAmount.add(Optional.ofNullable(budgetVo.getFirstReplyAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetVo.getActualReplyDiff()).orElse(BigDecimal.ZERO)));
            //已使用金额
            monthUseAmount = monthUseAmount.add(Optional.ofNullable(budgetVo.getApprovedAmount()).orElse(BigDecimal.ZERO)
                    .add(Optional.ofNullable(budgetVo.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(budgetVo.getApprovedAuditDiff()).orElse(BigDecimal.ZERO))));
        }
        budgetUseFormEntity.setMonthBudgetAmount(monthBudgetAmount);
        budgetUseFormEntity.setMonthUsedAmount(monthUseAmount);

        //预算点数(当月取计划,历史取实际)
        BigDecimal monthBudgetTotalPoint = BigDecimal.ZERO;
        if (date.equals(monthBudgetVo.getYearMonthLy())) {
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getPlanSaleAmount()) != 0) {
                monthBudgetTotalPoint = monthBudgetTotalPoint.add(monthBudgetAmount.divide(budgetUseFormEntity.getPlanSaleAmount(), 6, BigDecimal.ROUND_HALF_UP));
            }
        } else {
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getAcSaleAmount()) != 0) {
                monthBudgetTotalPoint = monthBudgetTotalPoint.add(monthBudgetAmount.divide(budgetUseFormEntity.getAcSaleAmount(), 6, BigDecimal.ROUND_HALF_UP));
            }
        }
        budgetUseFormEntity.setMonthBudgetTotalPoint(monthBudgetTotalPoint);

        //费用率 已使用金额/实际销量（如果计划量＞实销量，则取计划量；如果计划量≤实销量，则取实销量；）
        BigDecimal monthFeeRatio = BigDecimal.ZERO;
        if (budgetUseFormEntity.getAcSaleAmount().compareTo(budgetUseFormEntity.getPlanSaleAmount()) >= 0) {
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getAcSaleAmount()) != 0) {
                monthFeeRatio = monthUseAmount.divide(budgetUseFormEntity.getAcSaleAmount(), 6, BigDecimal.ROUND_HALF_UP);
            }
        } else {
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getPlanSaleAmount()) != 0) {
                monthFeeRatio = monthUseAmount.divide(budgetUseFormEntity.getPlanSaleAmount(), 6, BigDecimal.ROUND_HALF_UP);
            }
        }
        budgetUseFormEntity.setMonthFeeRatio(monthFeeRatio);

        //超支额度 已使用金额-预算金额
        budgetUseFormEntity.setMonthOverExpendAmount(budgetUseFormEntity.getMonthUsedAmount().subtract(budgetUseFormEntity.getMonthBudgetAmount()));
        //超支点数 超时额度/预算金额
        BigDecimal monthOverExpendTotalPoint = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getMonthBudgetAmount()) != 0) {
            monthOverExpendTotalPoint = monthOverExpendTotalPoint.add(budgetUseFormEntity.getMonthOverExpendAmount().divide(budgetUseFormEntity.getMonthBudgetAmount(), 6, BigDecimal.ROUND_HALF_UP));
        }
        budgetUseFormEntity.setMonthOverExpendPoint(monthOverExpendTotalPoint);
        if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getMonthOverExpendAmount()) <= 0){
            budgetUseFormEntity.setWarnType("预警");
        }else {
            budgetUseFormEntity.setWarnType("正常");
        }
        return budgetUseFormEntity;
    }

    /**
     * 年度逻辑处理
     *
     * @param budgetUseFormEntityList
     * @return
     */
    private List<BudgetUseFormEntity> buildYearParam(List<BudgetUseFormEntity> budgetUseFormEntityList, Map<String, List<YearBudgetVo>> yearBudgetVoMap, String nowDate) {
        for (BudgetUseFormEntity budgetUseFormEntity : budgetUseFormEntityList) {
            String yearMonth = budgetUseFormEntity.getYearAndMonth();
            BigDecimal budgetAmount = Optional.ofNullable(budgetUseFormEntity.getMonthBudgetAmount()).orElse(BigDecimal.ZERO);
            BigDecimal acItemSaleAmount = Optional.ofNullable(budgetUseFormEntity.getAcSaleAmount()).orElse(BigDecimal.ZERO);
            BigDecimal planItemSaleAmount = Optional.ofNullable(budgetUseFormEntity.getPlanSaleAmount()).orElse(BigDecimal.ZERO);
            BigDecimal overExpendAmount = Optional.ofNullable(budgetUseFormEntity.getMonthOverExpendAmount()).orElse(BigDecimal.ZERO);
            BigDecimal useAmount = Optional.ofNullable(budgetUseFormEntity.getMonthUsedAmount()).orElse(BigDecimal.ZERO);
            String systemCode = budgetUseFormEntity.getSystemCode();
            String regionCode = budgetUseFormEntity.getRegionCode();
            String budgetItemCode = budgetUseFormEntity.getBudgetItemCode();

            List<BudgetUseFormEntity> lowYearList = budgetUseFormEntityList.stream().filter(vo -> yearMonth.compareTo(vo.getYearAndMonth()) > 0).collect(Collectors.toList());
            for (BudgetUseFormEntity lowYearEntity : lowYearList) {
                //预算金额
                budgetAmount = budgetAmount.add(Optional.ofNullable(lowYearEntity.getMonthBudgetAmount()).orElse(BigDecimal.ZERO));
                //销额
                planItemSaleAmount = planItemSaleAmount.add(Optional.ofNullable(lowYearEntity.getPlanSaleAmount()).orElse(BigDecimal.ZERO));
                acItemSaleAmount = acItemSaleAmount.add(Optional.ofNullable(lowYearEntity.getAcSaleAmount()).orElse(BigDecimal.ZERO));
                //已使用金额
                useAmount = useAmount.add(Optional.ofNullable(lowYearEntity.getMonthUsedAmount()).orElse(BigDecimal.ZERO));
                //超支额度
                overExpendAmount = overExpendAmount.add(Optional.ofNullable(lowYearEntity.getMonthOverExpendAmount()).orElse(BigDecimal.ZERO));
            }
            budgetUseFormEntity.setBudgetAmount(budgetAmount);
            budgetUseFormEntity.setOverExpendAmount(overExpendAmount);
            budgetUseFormEntity.setUsedAmount(useAmount);

            //预算点数
            if (yearMonth.equals(nowDate)) {
                BigDecimal saleAmount = acItemSaleAmount.subtract(budgetUseFormEntity.getAcSaleAmount()).add(budgetUseFormEntity.getPlanSaleAmount());
                if (BigDecimal.ZERO.compareTo(saleAmount) != 0) {
                    budgetUseFormEntity.setBudgetTotalPoint(budgetAmount.divide(saleAmount, 6, BigDecimal.ROUND_HALF_UP));
                } else {
                    budgetUseFormEntity.setBudgetTotalPoint(BigDecimal.ZERO);
                }
            } else {
                if (BigDecimal.ZERO.compareTo(acItemSaleAmount) != 0) {
                    budgetUseFormEntity.setBudgetTotalPoint(budgetAmount.divide(acItemSaleAmount, 6, BigDecimal.ROUND_HALF_UP));
                } else {
                    budgetUseFormEntity.setBudgetTotalPoint(BigDecimal.ZERO);
                }
            }


            //费用率
            if (yearMonth.equals(nowDate)) {
                if (acItemSaleAmount.compareTo(planItemSaleAmount) >= 0 && BigDecimal.ZERO.compareTo(acItemSaleAmount) != 0) {
                    budgetUseFormEntity.setFeeRatio(useAmount.divide(acItemSaleAmount, 6, BigDecimal.ROUND_HALF_UP));
                } else if (acItemSaleAmount.compareTo(planItemSaleAmount) < 0 && BigDecimal.ZERO.compareTo(planItemSaleAmount) != 0) {
                    budgetUseFormEntity.setFeeRatio(useAmount.divide(planItemSaleAmount, 6, BigDecimal.ROUND_HALF_UP));
                } else {
                    budgetUseFormEntity.setFeeRatio(BigDecimal.ZERO);
                }
            }else {
                if (BigDecimal.ZERO.compareTo(acItemSaleAmount) != 0) {
                    budgetUseFormEntity.setFeeRatio(useAmount.divide(acItemSaleAmount, 6, BigDecimal.ROUND_HALF_UP));
                }else {
                    budgetUseFormEntity.setFeeRatio(BigDecimal.ZERO);
                }
            }


            //超支点数 超时额度/预算金额
            BigDecimal budgetTotalPoint = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getBudgetAmount()) != 0) {
                budgetTotalPoint = budgetTotalPoint.add(budgetUseFormEntity.getOverExpendAmount().divide(budgetUseFormEntity.getBudgetAmount(), 6, BigDecimal.ROUND_HALF_UP));
            }
            budgetUseFormEntity.setOverExpendPoint(budgetTotalPoint);

            //预算使用进度
            List<YearBudgetVo> yearBudgetVos = Optional.ofNullable(yearBudgetVoMap.get(StringUtils.join(systemCode, regionCode, budgetItemCode))).orElse(new ArrayList<>());
            if (!CollectionUtils.isEmpty(yearBudgetVos)) {
                yearBudgetVos = yearBudgetVos.stream().distinct().collect(Collectors.toList());
            }
            BigDecimal budgetTotalAmount = BigDecimal.ZERO;
            for (YearBudgetVo yearBudgetVo : yearBudgetVos) {
                budgetTotalAmount = budgetTotalAmount.add(Optional.ofNullable(yearBudgetVo.getBudgetTotalAmount()).orElse(BigDecimal.ZERO));
            }
            if (BigDecimal.ZERO.compareTo(budgetTotalAmount) != 0) {
                budgetUseFormEntity.setBudgetUseProgress(budgetUseFormEntity.getUsedAmount().divide(budgetTotalAmount, 6, BigDecimal.ROUND_HALF_UP));
            } else {
                budgetUseFormEntity.setBudgetUseProgress(BigDecimal.ZERO);
            }
            //销量进度
            SalesGoalDto dto = new SalesGoalDto();
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setYearMonthLy(yearMonth);
            dto.setSystemCode(systemCode);
            dto.setRegionCode(regionCode);
            dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            dto.setStartYearMonth(DateUtil.format(new Date(),DateUtil.DEFAULT_YEAR_MONTH).substring(0,4) + "-01");
            BigDecimal discountAfter = Optional.ofNullable(this.salesGoalServicel.findDiscountAfter(dto)).orElse(BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(discountAfter) != 0) {
                if (yearMonth.equals(nowDate)){
                    BigDecimal saleAmount = acItemSaleAmount.subtract(budgetUseFormEntity.getAcSaleAmount().add(budgetUseFormEntity.getPlanSaleAmount()));
                    budgetUseFormEntity.setSaleProgress(saleAmount.divide(discountAfter, 6, BigDecimal.ROUND_HALF_UP));
                }else {
                    budgetUseFormEntity.setSaleProgress(acItemSaleAmount.divide(discountAfter, 6, BigDecimal.ROUND_HALF_UP));
                }
            } else {
                budgetUseFormEntity.setSaleProgress(BigDecimal.ZERO);
            }
            //VS销量进度
            budgetUseFormEntity.setVsSaleProgress(budgetUseFormEntity.getBudgetUseProgress().subtract(budgetUseFormEntity.getSaleProgress()));
        }
        return budgetUseFormEntityList;
    }
}
