package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormAsyncService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormService;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;


import java.util.*;
import java.util.stream.Collectors;

/**
 * 预算使用监控报表(BudgetUseFormService)服务实现类
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@Slf4j
@Service("BudgetUseFormService")
public class BudgetUseFormServiceImpl implements BudgetUseFormService {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;


    @Autowired(required = false)
    private BudgetUseFormAsyncService budgetUseFormAsyncService;

    @Override
    public void createOrUpdateData(List<String> codes) {
        String nowDate = DateUtil.dateToStr(DateUtil.date_yyyy_MM, new Date());
        String tenantCode = TenantUtils.getTenantCode();
        String delCode = DelFlagStatusEnum.NORMAL.getCode();
        MonthBudgetDto dto = new MonthBudgetDto();
        List<MonthBudgetVo> listByConditions = new ArrayList<>();
        if (CollectionUtils.isEmpty(codes)) {
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setDelFlag(delCode);
            dto.setEnableStatus(delCode);
            dto.setTenantCode(tenantCode);
            dto.setDateDown(nowDate);
            dto.setYear(nowDate.substring(0, 4));
            listByConditions = this.monthBudgetService.findListByConditions(dto);
        } else {
            dto.setBudgetItemCodeList(codes);
            listByConditions = this.monthBudgetService.findListByConditions(dto);
        }
        if (CollectionUtils.isEmpty(listByConditions)) {
            return;
        }
        log.info("本次生成的预算使用数据量为{}", listByConditions.size());
        //查年度预算
        List<String> yearBudgetCode = listByConditions.stream().map(MonthBudgetVo::getYearBudgetCode).filter(vo -> StringUtils.isNotEmpty(vo)).distinct().collect(Collectors.toList());
        List<YearBudgetVo> yearBudgetList = yearBudgetSdkService.findYearBudgetByYearBudgetCodes(yearBudgetCode);
        Map<String, List<YearBudgetVo>> yearBudgetVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(yearBudgetList)) {
            yearBudgetVoMap = yearBudgetList.stream().filter(vo -> StringUtils.isNotEmpty(vo.getSystemCode()) && StringUtils.isNotEmpty(vo.getRegionCode()) && StringUtils.isNotEmpty(vo.getBudgetItemCode())).collect(Collectors.groupingBy(vo -> StringUtils.join(vo.getSystemCode(), vo.getRegionCode(), vo.getBudgetItemCode())));
        }

        Map<String, List<MonthBudgetVo>> monthBudgetMap = listByConditions.stream().collect(Collectors.groupingBy(vo -> StringUtils.join(vo.getRegionCode(), vo.getSystemCode(), vo.getBudgetItemCode())));

        List<String> collect = monthBudgetMap.keySet().stream().collect(Collectors.toList());
        log.info("按维度汇总后预算使用数据量为{}", collect.size());
        List<List<String>> partition = Lists.partition(collect, 2000);

        for (List<String> strings : partition) {
            this.budgetUseFormAsyncService.saveData(strings, monthBudgetMap, tenantCode, delCode, yearBudgetVoMap, nowDate);
        }
    }
}
