package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataResultVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.PriceMonitorFormEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.PriceMonitorFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormAsyncService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 价格管控报表(PriceMonitorFormAsyncService)服务实现类
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
@Slf4j
@Service("PriceMonitorFormAsyncService")
public class PriceMonitorFormAsyncServiceImpl implements PriceMonitorFormAsyncService {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private PriceMonitorFormRepository priceMonitorFormRepository;

    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED, rollbackFor = Exception.class)
    public void asyncBuildPriceMonitorForm(Map<String, List<SalesDataResultVo>> posMap, Map<String, List<PriceVo>> priceMap, Map<String, ProductVo> productVosMap,List<String> activityFormCodes) {
        log.info("进入线程开始进行细案匹配!");
        List<PriceMonitorFormEntity> entityList = new ArrayList<>();
        List<ActivityDetailPlanItemVo> planItemVoList = new ArrayList<>();
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        for (String key : posMap.keySet()) {
            List<SalesDataResultVo> salesDataResultVoList = posMap.get(key);
            SalesDataResultVo salesDataResultVo = salesDataResultVoList.get(0);
            log.info("pos匹配活动");
            //垂直查活动细案
            ActivityDetailPlanItemDto czQueryDto = new ActivityDetailPlanItemDto();
            czQueryDto.setBusinessFormatCode(salesDataResultVo.getBusinessFormatCode());
            czQueryDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            czQueryDto.setTerminalCode(salesDataResultVo.getStoreCode());
            czQueryDto.setProductCode(salesDataResultVo.getGoodsCode());
            czQueryDto.setNowTime(salesDataResultVo.getSalesDate());
            planItemVoList = Optional.ofNullable(activityDetailPlanItemSdkService.findByConditionsList(czQueryDto)).orElse(new ArrayList<>());
            //过滤活动形式
            planItemVoList = planItemVoList.stream().filter(vo -> activityFormCodes.contains(vo.getActivityFormCode())).collect(Collectors.toList());
            PriceMonitorFormEntity entity = this.buildParam(salesDataResultVoList, planItemVoList, priceMap, key, tenantCode, delFlag,productVosMap);
            entityList.add(entity);
            planItemVoList.clear();
        }
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        List<String> onlyKeys = entityList.stream().map(PriceMonitorFormEntity::getOnlyKey).distinct().collect(Collectors.toList());
        List<PriceMonitorFormEntity> byOnlyKeys = this.priceMonitorFormRepository.findByOnlyKeys(onlyKeys);
        List<PriceMonitorFormEntity> saveList = new ArrayList<>();
        List<PriceMonitorFormEntity> updateList = new ArrayList<>();
        if (CollectionUtils.isEmpty(byOnlyKeys)) {
            saveList.addAll(entityList);
        } else {
            Map<String, String> map = byOnlyKeys.stream()
                    .collect(Collectors.toMap(PriceMonitorFormEntity::getOnlyKey,
                            PriceMonitorFormEntity::getId, (newValue, oldValue) -> newValue));
            for (PriceMonitorFormEntity entity : entityList) {
                if (map.containsKey(entity.getOnlyKey())) {
                    String id = map.get(entity.getOnlyKey());
                    entity.setId(id);
                    updateList.add(entity);
                } else {
                    saveList.add(entity);
                }
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.priceMonitorFormRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.priceMonitorFormRepository.updateBatchById(updateList);
        }
    }


    private PriceMonitorFormEntity buildParam(List<SalesDataResultVo> value, List<ActivityDetailPlanItemVo> planItemVoList
            , Map<String, List<PriceVo>> priceMap, String key, String tenantCode, String delFlag,Map<String, ProductVo> productVosMap) {
        PriceMonitorFormEntity entity = new PriceMonitorFormEntity();
        SalesDataResultVo salesDataResultVo = value.get(0);
        //基础信息
        entity.setId(null);
        entity.setOnlyKey(key);
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(delFlag);
        entity.setSalesDate(salesDataResultVo.getSalesDate());
        entity.setSystemCode(salesDataResultVo.getDirectCode());
        entity.setSystemName(salesDataResultVo.getDirectName());
        entity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        entity.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        entity.setRegion(salesDataResultVo.getBusinessArea());
        entity.setKaStoreCode(salesDataResultVo.getKaStoreCode());
        entity.setTerminalCode(salesDataResultVo.getStoreCode());
        entity.setTerminalName(salesDataResultVo.getStoreName());
        entity.setProductCode(salesDataResultVo.getGoodsCode());
        entity.setProductName(salesDataResultVo.getGoodsName());
        entity.setUnitCode(salesDataResultVo.getMaxUnit());
        if (StringUtils.isNotEmpty(entity.getProductCode())){
            ProductVo productVo = productVosMap.get(entity.getProductCode());
            entity.setBrandCode(productVo.getProductBrandCode());
            entity.setBrandName(productVo.getProductBrandName());
            entity.setProductItemName(productVo.getProductLevelName());
            entity.setProductItemCode(productVo.getProductLevelCode());
            entity.setProductCategoryName(productVo.getProductCategoryName());
            entity.setProductCategoryCode(productVo.getProductCategoryCode());
        }
        //数量,销售金额
        BigDecimal num = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal promotionDeduction = BigDecimal.ZERO;
        for (SalesDataResultVo dataResultVo : value) {
            num = num.add(Optional.ofNullable(dataResultVo.getCurUnitSalesQuantity()).orElse(BigDecimal.ZERO));
            amount = amount.add(Optional.ofNullable(dataResultVo.getSalesAmount()).orElse(BigDecimal.ZERO));
            promotionDeduction = promotionDeduction.add(Optional.ofNullable(dataResultVo.getPromotionDeduction()).orElse(BigDecimal.ZERO));
        }
        entity.setQuantity(num);
        entity.setQuantityWarn("300");
        entity.setSaleAmount(amount);
        //终端价(销售金额（含税）/数量)
        if (BigDecimal.ZERO.compareTo(num) != 0) {
            entity.setTerminalPrice(amount.divide(num, 6, BigDecimal.ROUND_HALF_UP));
        }else {
            entity.setTerminalPrice(BigDecimal.ZERO);
        }
        if (!CollectionUtils.isEmpty(planItemVoList)){
            //匹配到多个活动时，取单间申请费用最高的
            planItemVoList = planItemVoList.stream().sorted(Comparator.comparing(ActivityDetailPlanItemVo::getSingleApplicationFee,Comparator.reverseOrder())).collect(Collectors.toList());
            ActivityDetailPlanItemVo activityDetailPlanItemVo = planItemVoList.get(0);
            if (Objects.nonNull(activityDetailPlanItemVo)) {
                //零售商
                if (StringUtil.isNotEmpty(activityDetailPlanItemVo.getSystemCode())){
                    entity.setSystemCode(activityDetailPlanItemVo.getSystemCode());
                    entity.setSystemName(activityDetailPlanItemVo.getSystemName());
                }
                //单位
                entity.setUnitCode(activityDetailPlanItemVo.getProductUnit());
                //区域
                entity.setRegion(activityDetailPlanItemVo.getRegion());
                entity.setRegionName(activityDetailPlanItemVo.getRegionName());
                //活动编码
                entity.setActivityCode(activityDetailPlanItemVo.getDetailPlanCode());
                //活动形式
                entity.setActivityFormDesc(activityDetailPlanItemVo.getRemark());
                entity.setActivityFormCode(activityDetailPlanItemVo.getActivityFormCode());
                entity.setActivityFormName(activityDetailPlanItemVo.getActivityFormName());
                //促销供价
                entity.setOriginalSupplyPrice(Optional.ofNullable(activityDetailPlanItemVo.getOriginalSupplyPrice()).orElse(BigDecimal.ZERO));
                //批复价
                entity.setApprovedPrice(activityDetailPlanItemVo.getPromotionalPrice());
                //实际供价=原拱价-单件实际扣费  单件实际扣费=促销扣款/数量
                BigDecimal acSupplyPrice = BigDecimal.ZERO;
                BigDecimal onePromotionDeduction = BigDecimal.ZERO;
                if (null != num && BigDecimal.ZERO.compareTo(num) != 0){
                    onePromotionDeduction = onePromotionDeduction.add(Optional.ofNullable(promotionDeduction.divide(num, 6, BigDecimal.ROUND_HALF_UP)).orElse(BigDecimal.ZERO));
                }
                acSupplyPrice = entity.getOriginalSupplyPrice().subtract(onePromotionDeduction);
                entity.setAcSupplyPrice(acSupplyPrice);
                List<PriceVo> priceVos = priceMap.get(entity.getProductCode());
                if (!CollectionUtils.isEmpty(priceVos)){
                    //红线价1 最高
                    entity.setRedPriceOne(Optional.ofNullable(priceVos.stream().max(Comparator.comparing(PriceVo::getPrice)).map(PriceVo::getPrice).get()).orElse(BigDecimal.ZERO));
                    //红线价2 最低
                    entity.setRedPriceTwo(Optional.ofNullable(priceVos.stream().min(Comparator.comparing(PriceVo::getPrice)).map(PriceVo::getPrice).get()).orElse(BigDecimal.ZERO));
                }
                //促销毛利(促销供价/促销售价)
                if (null != entity.getOriginalSupplyPrice() && null != entity.getApprovedPrice() && BigDecimal.ZERO.compareTo(entity.getApprovedPrice()) != 0) {
                    BigDecimal divide = entity.getOriginalSupplyPrice().divide(entity.getApprovedPrice(), 6, BigDecimal.ROUND_HALF_UP);
                    entity.setPromotionalGross(BigDecimal.ONE.subtract(divide));
                }
                //实际毛利(实际供价/实际售价,实际售价=终端价)
                if (null != entity.getAcSupplyPrice() && null != entity.getTerminalPrice() && BigDecimal.ZERO.compareTo(entity.getTerminalPrice()) != 0
                        && BigDecimal.ZERO.compareTo(entity.getAcSupplyPrice()) != 0) {
                    BigDecimal divide = entity.getAcSupplyPrice().divide(entity.getTerminalPrice(), 6, BigDecimal.ROUND_HALF_UP);
                    entity.setAcPromotionalGross(BigDecimal.ONE.subtract(divide));
                }else {
                    entity.setAcPromotionalGross(BigDecimal.ZERO);
                }
                //价格预警
                //单间申请费用
                BigDecimal singleApplicationFee = Optional.ofNullable(activityDetailPlanItemVo.getSingleApplicationFee()).orElse(BigDecimal.ZERO);
                if (Objects.nonNull(entity.getRedPriceTwo())){
                    if (singleApplicationFee.compareTo(entity.getRedPriceTwo()) <= 0) {
                        entity.setPriceWarn("1");
                    }
                }
                if (Objects.nonNull(entity.getRedPriceTwo()) && Objects.nonNull(entity.getRedPriceOne())){
                    if (entity.getRedPriceTwo().compareTo(singleApplicationFee) < 0 && singleApplicationFee.compareTo(entity.getRedPriceOne()) <= 0) {
                        entity.setPriceWarn("2");
                    }
                }
                if (Objects.nonNull(entity.getRedPriceOne())){
                    if (entity.getRedPriceOne().compareTo(singleApplicationFee) < 0) {
                        entity.setPriceWarn("3");
                    }
                }
                if (null == entity.getPriceWarn()){
                    entity.setPriceWarn("3");//默认绿灯
                }
                //毛利预警 实际毛利高于促销毛利红灯，低于绿灯
                if (null != entity.getAcPromotionalGross() && null != entity.getActivityFormCode() && null != entity.getPromotionalGross()) {
                    if (entity.getAcPromotionalGross().compareTo(entity.getPromotionalGross()) > 0) {
                        entity.setGrossWarn("1");
                    } else {
                        entity.setGrossWarn("3");
                    }
                }
                if (null == entity.getGrossWarn()){
                    entity.setGrossWarn("3");//默认绿灯
                }
            }
        }
        return entity;
    }
}
