package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.TpmPullPosDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataResultVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.vertical.form.table.local.dto.UpdateQuantityWarnDto;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.PriceMonitorFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormAsyncService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 价格监控表(BudgetUseFormService)服务实现类
 *
 * @author : cyj
 * @date : 2023-11-18
 */
@Slf4j
@Service("priceMonitorFormService")
public class PriceMonitorFormServiceImpl implements PriceMonitorFormService {

    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Autowired(required = false)
    private PriceMonitorFormAsyncService priceMonitorFormAsyncService;

    @Autowired(required = false)
    private PriceVoService priceVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;


    @Autowired(required = false)
    private PriceMonitorFormRepository priceMonitorFormRepository;

    @Override
    public void createOrUpdateData(TpmPullPosDto dto) {
        SalesDataDto salesDataDto = new SalesDataDto();
        if (Objects.nonNull(dto)) {
            salesDataDto.setSalesDate(dto.getSaleDate());
            salesDataDto.setModifyDate(dto.getModifyDate());
            salesDataDto.setDirectCode(dto.getDirectCode());
            salesDataDto.setDirectName(dto.getDirectName());
            salesDataDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        } else {
            salesDataDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            salesDataDto.setModifyDate(DateUtil.format(DateUtils.addDays(new Date(), -1), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        }

        //数据字典查
        List<DictDataVo> redLinePrice = Optional.ofNullable(dictDataVoService.findByDictTypeCode("red_line_price")).orElse(new ArrayList<>());
        List<String> redLinePriceType = redLinePrice.stream().map(DictDataVo::getDictCode).distinct().collect(Collectors.toList());
        Page<SalesDataResultVo> resultPage;
        long currentPage = 0;
        Pageable pageable = PageRequest.of(1, 200);
        log.info("=====>    价格监控数据 start    <=====");
        do {
            resultPage = this.invoiceSalesDataVoService.pageFindKmsPosByConditions(pageable, salesDataDto);
            currentPage = resultPage.getCurrent();
            pageable = pageable.next();
            if (currentPage == 1) {
                log.info("=====>    价格监控数据[POS数据]总数据量为:{}    <=====", resultPage.getTotal());
            }
            log.info("=====>    价格监控数据页码[{}/{}]    <=====", currentPage, resultPage.getPages());
            List<SalesDataResultVo> pageRecords = resultPage.getRecords();
            if (CollectionUtils.isEmpty(pageRecords)) {
                return;
            }
            this.matchedActivity(pageRecords, redLinePriceType);

        } while (resultPage.hasNext());
        log.info("=====>    价格监控数据 end    <=====");
    }

    @Override
    public void updateQuantityWarn(UpdateQuantityWarnDto dto) {
        Validate.notEmpty(dto.getId(), "id不能为空");
        Validate.notEmpty(dto.getQuantityWarn(), "预警数量不能为空");
        this.priceMonitorFormRepository.updateQuantityWarn(dto);

    }

    private void matchedActivity(List<SalesDataResultVo> salesDataResultVoList, List<String> redLinePriceType) {
        if (CollectionUtils.isEmpty(salesDataResultVoList)) {
            return;
        }
        Map<String, List<SalesDataResultVo>> posMap = salesDataResultVoList.stream()
                .filter(vo -> StringUtils.isNotEmpty(vo.getSalesDate())
                        && StringUtils.isNotEmpty(vo.getStoreCode())
                        && StringUtils.isNotEmpty(vo.getGoodsCode()))
                .collect(Collectors.groupingBy(vo -> StringUtils.joinWith("-", vo.getSalesDate(), vo.getStoreCode(), vo.getGoodsCode())));
        log.info("本次价格监控数据量为:{}", posMap.keySet().size());
        if (MapUtils.isNotEmpty(posMap)) {
            //找产品
            Map<String, ProductVo> productVosMap = new HashMap<>();
            List<String> productCodeList = salesDataResultVoList.stream().filter(vo -> StringUtils.isNotEmpty(vo.getGoodsCode())).map(SalesDataResultVo::getGoodsCode).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(productCodeList)) {
                ProductQueryDto productdto = new ProductQueryDto();
                productdto.setProductCodeList(productCodeList);
                List<ProductVo> productVos = this.productVoService.findByQueryDto(productdto);
                if (!CollectionUtils.isEmpty(productVos)) {
                    productVosMap.putAll(productVos.stream()
                            .collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (oldValue, newValue) -> newValue)));
                }
            }

            List<String> goodsCodes = salesDataResultVoList.stream().filter(vo -> StringUtils.isNotEmpty(vo.getGoodsCode())).map(SalesDataResultVo::getGoodsCode).distinct().collect(Collectors.toList());
            PriceDto priceDto = new PriceDto();
            priceDto.setTypeCodes(redLinePriceType);
            priceDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            priceDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            priceDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            priceDto.setGoodsCodes(goodsCodes);
            List<PriceVo> priceVoList = Optional.ofNullable(this.priceVoService.findByPriceDtoRedLine(priceDto)).orElse(new ArrayList<>());

            Map<String, List<PriceVo>> priceMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(priceVoList)) {
                priceMap = priceVoList.stream().collect(Collectors.groupingBy(PriceVo::getGoodsCode));
            }

            //活动形式
            List<String> activityFormCodes = this.activityFormService.findActivityFormCodeFromPromotionsType(BusinessUnitEnum.VERTICAL.getCode(), VerticalActivityTypeEnum.promotions.getCode(), "2");
            this.priceMonitorFormAsyncService.asyncBuildPriceMonitorForm(posMap, priceMap, productVosMap, activityFormCodes);
        }
    }
}
