package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.tpm.business.son.company.report.sdk.service.SubComReportService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 利润监控预警配置
 */
@Service
public class PromotionProgressIntensityMonitorRegisterAbstract extends AbstractTpmWarningMonitoringVariableRegister {

    @Autowired(required = false)
    private SubComReportService subComReportService;

    public static final String monitoringTable = "tpm_promotion_progress_intensity_monitor";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("exceed_retail_red_price");
        tpmWarningMonitoringVariable.setVariableFieldName("是否超零售红线价");
        tpmWarningMonitoringVariable.setVariableQueryField("exceed_retail_red_price");
        variableList.add(tpmWarningMonitoringVariable);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable1 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable1.setVariableField("exceed_supply_red_price");
        tpmWarningMonitoringVariable1.setVariableFieldName("是否超供货红线价");
        tpmWarningMonitoringVariable1.setVariableQueryField("exceed_supply_red_price");
        variableList.add(tpmWarningMonitoringVariable1);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable2 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable2.setVariableField("execute_progress");
        tpmWarningMonitoringVariable2.setVariableFieldName("活动执行进度");
        tpmWarningMonitoringVariable2.setVariableQueryField("execute_progress");
        variableList.add(tpmWarningMonitoringVariable2);
        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        String appendWhereSql = super.appendWhereSql(conditionList);
        return this.subComReportService.findPromotionProgressIntensityMonitorByMonitorWarning(appendWhereSql);
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

}
