package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.tpm.business.son.company.report.sdk.service.SubComReportService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 销量监控(品项)预警配置
 */
@Service
public class SalesAndFeeMonitorRegisterAbstract extends AbstractTpmWarningMonitoringVariableRegister {

    @Autowired(required = false)
    private SubComReportService subComReportService;

    public static final String monitoringTable = "tpm_sales_and_fee_monitor";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("sale_put_product_ratio_diff");
        tpmWarningMonitoringVariable.setVariableFieldName("销售投产比差");
        tpmWarningMonitoringVariable.setVariableQueryField("sale_put_product_ratio_diff");
        variableList.add(tpmWarningMonitoringVariable);
        return variableList;
    }

    @Override
    public List<Map<String, Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        String appendWhereSql = super.appendWhereSql(conditionList);
        return this.subComReportService.findSalesAndFeeByMonitorWarning(appendWhereSql);
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

}
