package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.tpm.business.son.company.report.sdk.service.SubComReportService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 利润监控预警配置
 */
@Service
public class SubComProfitMonitorRegisterAbstract extends AbstractTpmWarningMonitoringVariableRegister {

    @Autowired(required = false)
    private SubComReportService subComReportService;

    public static final String monitoringTable = "tpm_sub_com_profit_monitor";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("profit_deviation");
        tpmWarningMonitoringVariable.setVariableFieldName("利润偏差");
        tpmWarningMonitoringVariable.setVariableQueryField("profit_deviation");
        variableList.add(tpmWarningMonitoringVariable);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable1 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable1.setVariableField("profit_margin_deviation");
        tpmWarningMonitoringVariable1.setVariableFieldName("利润率偏差");
        tpmWarningMonitoringVariable1.setVariableQueryField("profit_margin_deviation");
        variableList.add(tpmWarningMonitoringVariable1);
        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        String appendWhereSql = super.appendWhereSql(conditionList);
        return this.subComReportService.findByMonitorWarning(appendWhereSql);
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

}
