package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.ActivityReturnTransGiftService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 报表 job
 *
 * @author cyj
 * @version 1.0
 * @date 2023/1/10 16:00
 * @description VerticalFormTableXxJob
 */
@Slf4j
@Service
public class VerticalFormTableXxJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ActivityReturnTransGiftService activityReturnTransGiftService;

    @Autowired(required = false)
    private BudgetUseFormService budgetUseFormService;

    @Autowired(required = false)
    private PriceMonitorFormService priceMonitorFormService;

    /**
     * 垂直退转赠报表(垂直)
     */
    @DynamicTaskService(cornExpression = "0 0 2 * * ?", taskDesc = "垂直退转赠报表(垂直)")
    public void activityReturnTransGiftCreate() {
        loginUserService.refreshAuthentication(null);
        activityReturnTransGiftService.createOrUpdateData(null);
    }

    /**
     * 预算使用监控报表(垂直)
     */
    @DynamicTaskService(cornExpression = "0 0 3 * * ?", taskDesc = "预算使用监控报表(垂直)")
    public void budgetUseFormCreate() {
        loginUserService.refreshAuthentication(null);
        budgetUseFormService.createOrUpdateData(null);
    }

    /**
     * 终端价格监控报表(垂直)
     */
    @DynamicTaskService(cornExpression = "0 0 1 * * ?", taskDesc = "终端价格监控报表(垂直)")
    public void createOrUpdateDataPriceMonitor() {
        loginUserService.refreshAuthentication(null);
        priceMonitorFormService.createOrUpdateData(null);
    }
}
