package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.ActivityReturnTransGiftRepository;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.ActivityReturnMonitorWarningQueryDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 活动退转赠-预警监控配置
 * @author wanghaojia
 * @date 2023/6/14 15:32
 */
@Service
public class WarningActivityReturnTransGiftRegisterAbstract extends AbstractTpmWarningMonitoringVariableRegister {

    @Autowired(required = false)
    private ActivityReturnTransGiftRepository activityReturnTransGiftRepository;

    public static final String monitoringTable = "tpm_activity_return_trans_gift";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();

//        当前日期、区域、零售商、门店、产品、实际退货（月累退货数量）、申请退转赠数量（申请数量）、实际退货金额（月累退货金额）、申请退货金额（申请金额）
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("now_date");
        tpmWarningMonitoringVariable.setVariableFieldName("当前日期");
        tpmWarningMonitoringVariable.setVariableQueryField("now_date");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("region_name");
        tpmWarningMonitoringVariable.setVariableFieldName("区域");
        tpmWarningMonitoringVariable.setVariableQueryField("region_name");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("system_name");
        tpmWarningMonitoringVariable.setVariableFieldName("零售商");
        tpmWarningMonitoringVariable.setVariableQueryField("system_name");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("terminal_name");
        tpmWarningMonitoringVariable.setVariableFieldName("门店");
        tpmWarningMonitoringVariable.setVariableQueryField("terminal_name");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("product_name");
        tpmWarningMonitoringVariable.setVariableFieldName("产品");
        tpmWarningMonitoringVariable.setVariableQueryField("product_name");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("month_return_num");
        tpmWarningMonitoringVariable.setVariableFieldName("实际退货");
        tpmWarningMonitoringVariable.setVariableQueryField("month_return_num");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("quantity");
        tpmWarningMonitoringVariable.setVariableFieldName("申请退转赠数量");
        tpmWarningMonitoringVariable.setVariableQueryField("quantity");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("month_return_amount");
        tpmWarningMonitoringVariable.setVariableFieldName("实际退货金额");
        tpmWarningMonitoringVariable.setVariableQueryField("month_return_amount");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("apply_amount");
        tpmWarningMonitoringVariable.setVariableFieldName("申请退货金额");
        tpmWarningMonitoringVariable.setVariableQueryField("apply_amount");
        variableList.add(tpmWarningMonitoringVariable);

        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        ActivityReturnMonitorWarningQueryDto dto = new ActivityReturnMonitorWarningQueryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        List<Map<String, Object>> list = activityReturnTransGiftRepository.findActivityReturnMonitorWarning(dto);
        String nowDate = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        for (Map<String, Object> objectMap : list) {
            objectMap.put("now_date",nowDate);
        }
        return list;
        

    }

    @Override
    public String businessCodeField() {
        return "id";
    }

}
