package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.tpm.business.vertical.form.table.local.repository.BudgetUseFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.BudgetUseFormWarningQueryDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 预算使用监控报表-预警监控配置
 * @author wanghaojia
 * @date 2023/6/14 15:32
 */
@Service
public class WarningBudgetUseFormRegisterAbstract extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {

    @Autowired(required = false)
    private BudgetUseFormRepository budgetUseFormRepository;

    public static final String monitoringTable = "tpm_budget_use_form";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("region_name");
        tpmWarningMonitoringVariable.setVariableFieldName("区域");
        tpmWarningMonitoringVariable.setVariableQueryField("region_name");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("system_name");
        tpmWarningMonitoringVariable.setVariableFieldName("零售商");
        tpmWarningMonitoringVariable.setVariableQueryField("system_name");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("year_and_month");
        tpmWarningMonitoringVariable.setVariableFieldName("年月");
        tpmWarningMonitoringVariable.setVariableQueryField("year_and_month");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("month_budget_amount");
        tpmWarningMonitoringVariable.setVariableFieldName("本月可用预算");
        tpmWarningMonitoringVariable.setIsGroup(true);
        tpmWarningMonitoringVariable.setVariableQueryField("month_budget_amount");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("month_fee_ratio");
        tpmWarningMonitoringVariable.setVariableFieldName("本月费用率 ");
        tpmWarningMonitoringVariable.setVariableQueryField("month_fee_ratio");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("over_expend_amount");
        tpmWarningMonitoringVariable.setVariableFieldName("累计超支额度");
        tpmWarningMonitoringVariable.setVariableQueryField("IFNULL(t.over_expend_amount,0)");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("negate_over_expend_amount");
        tpmWarningMonitoringVariable.setVariableFieldName("累计节超额度");
        tpmWarningMonitoringVariable.setVariableQueryField("IFNULL(-t.over_expend_amount,0)");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("vs_sale_progress");
        tpmWarningMonitoringVariable.setVariableFieldName("累计费用使用进度-销量达成进度");
        tpmWarningMonitoringVariable.setVariableQueryField("vs_sale_progress");
        variableList.add(tpmWarningMonitoringVariable);

        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        BudgetUseFormWarningQueryDto dto = new BudgetUseFormWarningQueryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        return budgetUseFormRepository.findBudgetUseFormMonitorWarning(dto);
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

    @Override
    public List<String> defaultDimensionKey() {
        return Lists.newArrayList("year_and_month");
    }

    @Override
    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return "region_code";
            case SYSTEM:
                return "system_code";
        }
        return null;
    }

    @Override
    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return Lists.newArrayList("region_code","region_name");
            case SYSTEM:
                return Lists.newArrayList("system_code","system_name");
        }
        return org.apache.commons.compress.utils.Lists.newArrayList();
    }

}
