
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.ect.business.account.checking.dto.report.AcountPeriodReportDto;
import com.biz.crm.ect.business.account.checking.service.AccountPeriodReportVoService;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * ECT-账期集团版报表预警
 */
@Service
public class WarningEctAccountPeriodGroupFormRegisterAbstract extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {

    public static final String monitoringTable = "ect_account_period_group_form";

    @Autowired(required = false)
    private AccountPeriodReportVoService accountPeriodReportVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private DirectVoService directVoService;

    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("shopkeeper_code");
        tpmWarningMonitoringVariable.setVariableFieldName("系统编码");
        tpmWarningMonitoringVariable.setVariableQueryField("shopkeeper_code");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("shopkeeper_name");
        tpmWarningMonitoringVariable.setVariableFieldName("系统");
        tpmWarningMonitoringVariable.setVariableQueryField("shopkeeper_name");
        variableList.add(tpmWarningMonitoringVariable);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable2 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable2.setVariableField("area");
        tpmWarningMonitoringVariable2.setVariableFieldName("大区");
        tpmWarningMonitoringVariable2.setVariableQueryField("area");
        variableList.add(tpmWarningMonitoringVariable2);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable4 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable4.setVariableField("not_receivable_money_tax");
        tpmWarningMonitoringVariable4.setVariableFieldName("未回款金额");
        tpmWarningMonitoringVariable4.setVariableQueryField("not_receivable_money_tax");
        tpmWarningMonitoringVariable4.setIsGroup(true);
        tpmWarningMonitoringVariable4.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable4);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable5 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable5.setVariableField("receivable_over_days");
        tpmWarningMonitoringVariable5.setVariableFieldName("回款逾期天数");
        tpmWarningMonitoringVariable5.setVariableQueryField("receivable_over_days");
        tpmWarningMonitoringVariable5.setIsGroup(true);
        tpmWarningMonitoringVariable5.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable5);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable6 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable6.setVariableField("not_ticket_money_tax");
        tpmWarningMonitoringVariable6.setVariableFieldName("未回票金额");
        tpmWarningMonitoringVariable6.setVariableQueryField("not_ticket_money_tax");
        tpmWarningMonitoringVariable6.setIsGroup(true);
        tpmWarningMonitoringVariable6.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable6);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable7 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable7.setVariableField("ticket_over_days");
        tpmWarningMonitoringVariable7.setVariableFieldName("回票逾期天数");
        tpmWarningMonitoringVariable7.setVariableQueryField("ticket_over_days");
        tpmWarningMonitoringVariable7.setIsGroup(true);
        tpmWarningMonitoringVariable7.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable7);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable8 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable8.setVariableField("ticket_date");
        tpmWarningMonitoringVariable8.setVariableFieldName("应回票日期");
        tpmWarningMonitoringVariable8.setVariableQueryField("ticket_date");
        variableList.add(tpmWarningMonitoringVariable8);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable9 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable9.setVariableField("group_receivable_date");
        tpmWarningMonitoringVariable9.setVariableFieldName("应回款日期");
        tpmWarningMonitoringVariable9.setVariableQueryField("group_receivable_date");
        variableList.add(tpmWarningMonitoringVariable9);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable10 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable10.setVariableField("area_name");
        tpmWarningMonitoringVariable10.setVariableFieldName("区域名称");
        tpmWarningMonitoringVariable10.setVariableQueryField("area_name");
        variableList.add(tpmWarningMonitoringVariable10);

        return variableList;
    }

    @Override
    public List<Map<String, Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        AcountPeriodReportDto dto = new AcountPeriodReportDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        dto.setQueryFlag("group");

        List<Map<String, Object>> list = accountPeriodReportVoService.acountPeriodReportWarning(dto);
        Map<String, String> regionMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_CUSTOMIZE_ORG);
        if (!CollectionUtils.isEmpty(regionMap)){
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> stringObjectMap = list.get(i);
                if (!stringObjectMap.containsKey("area")){
                    continue;
                }
                Object businessAreaObj = stringObjectMap.get("area");
                if (null == businessAreaObj){
                    continue;
                }
                String businessAreaName = regionMap.get(businessAreaObj.toString());
                stringObjectMap.put("area_name",businessAreaName);
                list.set(i, stringObjectMap);
            }
        }

        //转换下零售商编码，从KMS直营体系编码转换成MDM零售商编码
        List<String> systemCodeList = list.stream().map(item -> item.get("shopkeeper_code")).filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(systemCodeList)) {
            List<DirectVo> directVos = directVoService.findByDirectCodes(systemCodeList);
            if (ObjectUtils.isNotEmpty(directVos)) {
                Map<String, String> directMap = directVos.stream().collect(Collectors.toMap(DirectVo::getDirectCode, DirectVo::getCustomerRetailerCode, (o, n) -> n));
                for (int i = 0; i < list.size(); i++) {
                    Map<String, Object> objectMap = list.get(i);
                    Object systemCodeObj = objectMap.get("shopkeeper_code");
                    if (null == systemCodeObj){
                        continue;
                    }
                    String systemCode = systemCodeObj.toString();
                    objectMap.put("shopkeeper_code", directMap.getOrDefault(systemCode,systemCode));
                    list.set(i, objectMap);
                }
            }
        }

        return list;
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

    @Override
    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return "area_name";
            case SYSTEM:
                return "shopkeeper_code";
        }
        return null;
    }

    @Override
    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return com.google.common.collect.Lists.newArrayList("area","area_name");
            case SYSTEM:
                return com.google.common.collect.Lists.newArrayList("shopkeeper_code","shopkeeper_name");
        }
        return Lists.newArrayList();
    }

}
