package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSummaryDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSummaryVoService;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * KMS-稽核汇总表预警
 */
@Service
public class WarningKmsAuditSummaryFormRegisterAbstract extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {


    public static final String monitoringTable = "kms_audit_summary_form";


    @Autowired(required = false)
    private AuditSummaryVoService auditSummaryVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("create_time");
        tpmWarningMonitoringVariable.setVariableFieldName("创建日期");
        tpmWarningMonitoringVariable.setVariableQueryField("create_time");
        variableList.add(tpmWarningMonitoringVariable);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable2 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable2.setVariableField("time_range_end");
        tpmWarningMonitoringVariable2.setVariableFieldName("汇总结束日期");
        tpmWarningMonitoringVariable2.setVariableQueryField("time_range_end");
        variableList.add(tpmWarningMonitoringVariable2);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable3 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable3.setVariableField("grab_sap_total");
        tpmWarningMonitoringVariable3.setVariableFieldName("105总条数");
        tpmWarningMonitoringVariable3.setVariableQueryField("grab_sap_total");
        tpmWarningMonitoringVariable3.setIsGroup(true);
        tpmWarningMonitoringVariable3.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable3);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable4 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable4.setVariableField("zor2_total");
        tpmWarningMonitoringVariable4.setVariableFieldName("105内Z0R2条数");
        tpmWarningMonitoringVariable4.setVariableQueryField("zor2_total");
        tpmWarningMonitoringVariable4.setIsGroup(true);
        tpmWarningMonitoringVariable4.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable4);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable5 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable5.setVariableField("sap_total");
        tpmWarningMonitoringVariable5.setVariableFieldName("稽核单数量");
        tpmWarningMonitoringVariable5.setVariableQueryField("sap_total");
        tpmWarningMonitoringVariable5.setIsGroup(true);
        tpmWarningMonitoringVariable5.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable5);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable6 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable6.setVariableField("audit_confirm");
        tpmWarningMonitoringVariable6.setVariableFieldName("稽核单-已确认");
        tpmWarningMonitoringVariable6.setVariableQueryField("audit_confirm");
        tpmWarningMonitoringVariable6.setIsGroup(true);
        tpmWarningMonitoringVariable6.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable6);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable7 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable7.setVariableField("audit_match");
        tpmWarningMonitoringVariable7.setVariableFieldName("稽核单-已匹配");
        tpmWarningMonitoringVariable7.setVariableQueryField("audit_match");
        tpmWarningMonitoringVariable7.setIsGroup(true);
        tpmWarningMonitoringVariable7.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable7);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable8 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable8.setVariableField("audit_match_differ");
        tpmWarningMonitoringVariable8.setVariableFieldName("稽核单-已匹配有差异");
        tpmWarningMonitoringVariable8.setVariableQueryField("audit_match_differ");
        tpmWarningMonitoringVariable8.setIsGroup(true);
        tpmWarningMonitoringVariable8.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable8);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable9 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable9.setVariableField("audit_match_fail");
        tpmWarningMonitoringVariable9.setVariableFieldName("稽核单-匹配失败");
        tpmWarningMonitoringVariable9.setVariableQueryField("audit_match_fail");
        tpmWarningMonitoringVariable9.setIsGroup(true);
        tpmWarningMonitoringVariable9.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable9);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable10 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable10.setVariableField("audit_match_wait");
        tpmWarningMonitoringVariable10.setVariableFieldName("稽核单-待匹配");
        tpmWarningMonitoringVariable10.setVariableQueryField("audit_match_wait");
        tpmWarningMonitoringVariable10.setIsGroup(true);
        tpmWarningMonitoringVariable10.setGroupScale(0);
        variableList.add(tpmWarningMonitoringVariable10);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable11 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable11.setVariableField("direct_code");
        tpmWarningMonitoringVariable11.setVariableFieldName("系统编码");
        tpmWarningMonitoringVariable11.setVariableQueryField("direct_code");
        variableList.add(tpmWarningMonitoringVariable11);

        TpmWarningMonitoringVariable tpmWarningMonitoringVariable12 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable12.setVariableField("direct_name");
        tpmWarningMonitoringVariable12.setVariableFieldName("系统名称");
        tpmWarningMonitoringVariable12.setVariableQueryField("direct_name");
        variableList.add(tpmWarningMonitoringVariable12);


        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("customer_retailer_code");
        tpmWarningMonitoringVariable.setVariableFieldName("零售商编码");
        tpmWarningMonitoringVariable.setVariableQueryField("customer_retailer_code");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("customer_retailer_name");
        tpmWarningMonitoringVariable.setVariableFieldName("零售商名称");
        tpmWarningMonitoringVariable.setVariableQueryField("customer_retailer_name");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("business_area");
        tpmWarningMonitoringVariable.setVariableFieldName("区域编码");
        tpmWarningMonitoringVariable.setVariableQueryField("business_area");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("business_area_name");
        tpmWarningMonitoringVariable.setVariableFieldName("区域名称");
        tpmWarningMonitoringVariable.setVariableQueryField("business_area_name");
        variableList.add(tpmWarningMonitoringVariable);

        return variableList;
    }

    @Override
    public List<Map<String, Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        AuditSummaryDto dto = new AuditSummaryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        List<Map<String, Object>> list = auditSummaryVoService.auditSummaryWarning(dto);
        Map<String, String> regionMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_CUSTOMIZE_ORG);
        if (!CollectionUtils.isEmpty(regionMap)){
            for (Map<String, Object> stringObjectMap : list) {
                if (!stringObjectMap.containsKey("business_area")){
                    continue;
                }
                Object businessAreaObj = stringObjectMap.get("business_area");
                if (null == businessAreaObj){
                    continue;
                }
                String businessAreaName = regionMap.get(businessAreaObj.toString());
                stringObjectMap.put("business_area_name",businessAreaName);
            }
        }
        return list;
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

    @Override
    public List<String> defaultDimensionKey() {
        return com.google.common.collect.Lists.newArrayList("create_time","time_range_end");
    }

    @Override
    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return "business_area";
            case SYSTEM:
                return "customer_retailer_code";
        }
        return null;
    }

    @Override
    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return com.google.common.collect.Lists.newArrayList("business_area","business_area_name");
            case SYSTEM:
                return com.google.common.collect.Lists.newArrayList("customer_retailer_code","customer_retailer_name");
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Map<String, Object>> groupList(TpmWarningConfigDto dto, List<Map<String, Object>> dataList) {
        return super.groupList(dto, dataList);
    }
}
