package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.PriceMonitorFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.PriceMonitorFormWarningQueryDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 终端价格预警表-预警监控配置
 * @author wanghaojia
 * @date 2023/6/14 15:32
 */
@Service
public class WarningPriceMonitorFormRegisterAbstract extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {

    @Autowired(required = false)
    private PriceMonitorFormRepository priceMonitorFormRepository;

    public static final String monitoringTable = "tpm_price_monitor_form";

    public static final String FIELD_SYSTEM_CODE = "system_code";

    @Autowired(required = false)
    private DirectVoService directVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
//        【区域】、【系统】、【产品名称】、【pos成交价（系统上取终端价）】、【红线价1】
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("currDay");
        tpmWarningMonitoringVariable.setVariableFieldName("当前日期");
        tpmWarningMonitoringVariable.setVariableQueryField("currDay");
        tpmWarningMonitoringVariable.setIsWaring(true);
        tpmWarningMonitoringVariable.setIsCondition(false);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("region_name");
        tpmWarningMonitoringVariable.setVariableFieldName("区域");
        tpmWarningMonitoringVariable.setVariableQueryField("region_name");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("system_name");
        tpmWarningMonitoringVariable.setVariableFieldName("系统");
        tpmWarningMonitoringVariable.setVariableQueryField("system_name");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("product_name");
        tpmWarningMonitoringVariable.setVariableFieldName("产品名称");
        tpmWarningMonitoringVariable.setVariableQueryField("product_name");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("approved_price");
        tpmWarningMonitoringVariable.setVariableFieldName("批复价单价");
        tpmWarningMonitoringVariable.setVariableQueryField("approved_price");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("terminal_price");
        tpmWarningMonitoringVariable.setVariableFieldName("pos成交价单价");
        tpmWarningMonitoringVariable.setVariableQueryField("terminal_price");
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("red_price_one");
        tpmWarningMonitoringVariable.setVariableFieldName("红线价1");
        tpmWarningMonitoringVariable.setVariableQueryField("red_price_one");
        variableList.add(tpmWarningMonitoringVariable);

        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        PriceMonitorFormWarningQueryDto dto = new PriceMonitorFormWarningQueryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        List<Map<String, Object>> list = priceMonitorFormRepository.findPriceMonitorFormWarning(dto);

        List<String> dictCodeList = com.google.common.collect.Lists.newArrayList("MDM_CUSTOMIZE_ORG");
        Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
        Map<String, Map<String, String>> dictMapMap = !org.springframework.util.CollectionUtils.isEmpty(dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n)) : new HashMap<>();
        Map<String, String> regionMap = dictMapMap.get("MDM_CUSTOMIZE_ORG");

        String currDay = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        for (Map<String, Object> stringObjectMap : list) {
            stringObjectMap.put("currDay",currDay);
            Object regionObj = stringObjectMap.get("region");
            if (null != regionObj){
                stringObjectMap.put("region_name",regionMap.get(regionObj.toString()));
            }
        }

        //转换下零售商编码，从KMS直营体系编码转换成MDM零售商编码
        List<String> systemCodeList = list.stream().map(item -> item.get(FIELD_SYSTEM_CODE)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(systemCodeList)){
            List<DirectVo> directVos = directVoService.findByDirectCodes(systemCodeList);
            if (!CollectionUtils.isEmpty(directVos)){
                Map<String, String> directMap = directVos.stream().collect(Collectors.toMap(DirectVo::getDirectCode, DirectVo::getCustomerRetailerCode, (o, n) -> n));
                for (Map<String, Object> objectMap : list) {
                    Object systemCodeObj = objectMap.get(FIELD_SYSTEM_CODE);
                    if (null == systemCodeObj){
                        continue;
                    }
                    String systemCode = systemCodeObj.toString();
                    objectMap.put(FIELD_SYSTEM_CODE,directMap.getOrDefault(systemCode,systemCode));
                }
            }
        }
        return list;
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

    @Override
    public List<String> defaultDimensionKey() {
        return Lists.newArrayList("currDay");
    }

    @Override
    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return "region";
            case SYSTEM:
                return "system_code";
        }
        return null;
    }

    @Override
    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return com.google.common.collect.Lists.newArrayList("region","region_name");
            case SYSTEM:
                return com.google.common.collect.Lists.newArrayList("system_code","system_name");
        }
        return org.apache.commons.compress.utils.Lists.newArrayList();
    }

}
