package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.ProgressReferendumCostPlanFormVoService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 公投费用规划进度预警配置
 */
@Service
public class WarningProgressReferendumCostPlanRegisterAbstract extends AbstractTpmWarningMonitoringVariableRegister {

    @Autowired(required = false)
    private ProgressReferendumCostPlanFormVoService progressReferendumCostPlanFormVoService;

    public static final String monitoringTable = "tpm_progress_referendum_cost_plan_form";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("actual_down_un_plan_amount");
        tpmWarningMonitoringVariable.setVariableFieldName("实际向下剩余未规划金额");
        tpmWarningMonitoringVariable.setVariableQueryField("actual_down_un_plan_amount");
        variableList.add(tpmWarningMonitoringVariable);
        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        String appendWhereSql = super.appendWhereSql(conditionList);
        return this.progressReferendumCostPlanFormVoService.findByMonitorWarning(appendWhereSql);
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

}
