/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.returns.order.sdk.dto.ReturnOrderDto;
import com.biz.crm.kms.business.invoice.returns.order.sdk.service.ReturnOrderVoService;
import com.biz.crm.kms.business.invoice.returns.order.sdk.vo.TpmReturnOrderVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.ActivityReturnTransGiftEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.ActivityReturnTransGiftRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.ActivityReturnTransGiftService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ActivityReturnTransGiftService")
public class ActivityReturnTransGiftServiceImpl
implements ActivityReturnTransGiftService {
    private static final Logger log = LoggerFactory.getLogger(ActivityReturnTransGiftServiceImpl.class);
    private static final String RETURNTRANSGIFT = "HDXS2023011100035";
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ReturnOrderVoService returnOrderVoService;
    @Autowired(required=false)
    private ActivityReturnTransGiftRepository activityReturnTransGiftRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdateData(List<String> codes) {
        ActivityDetailPlanItemDto queryDto = new ActivityDetailPlanItemDto();
        if (CollectionUtil.isEmpty(codes)) {
            queryDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            queryDto.setActivityYearMonth(DateUtil.getDate((String)"yyyy-MM"));
            queryDto.setActivityFormCode(RETURNTRANSGIFT);
        } else {
            queryDto.setDetailPlanItemCodeList(codes);
        }
        PageRequest pageable = PageRequest.of((int)1, (int)2000);
        queryDto.setActivityFormCode(RETURNTRANSGIFT);
        Page byConditions = this.activityDetailPlanItemSdkService.findByConditions((Pageable)pageable, queryDto);
        ArrayList activityDetailPlanItemVoList = new ArrayList();
        activityDetailPlanItemVoList.addAll(byConditions.getRecords());
        while (byConditions.hasNext()) {
            pageable = pageable.next();
            byConditions = this.activityDetailPlanItemSdkService.findByConditions((Pageable)pageable, queryDto);
            activityDetailPlanItemVoList.addAll(byConditions.getRecords());
        }
        if (CollectionUtil.isEmpty(activityDetailPlanItemVoList)) {
            return;
        }
        log.info("\u672c\u6b21\u66f4\u65b0\u6570\u636e\u91cf{}", (Object)activityDetailPlanItemVoList.size());
        Map<String, List<ActivityDetailPlanItemVo>> groupPlanItemMap = activityDetailPlanItemVoList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getSystemCode()) && StringUtils.isNotEmpty((CharSequence)vo.getRegion()) && StringUtils.isNotEmpty((CharSequence)vo.getTerminalCode()) && StringUtils.isNotEmpty((CharSequence)vo.getProductCode())).collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getSystemCode(), vo.getRegion(), vo.getTerminalCode(), vo.getProductCode(), DateUtil.format((Date)vo.getActivityBeginDate(), (String)"yyyy-MM")})));
        ReturnOrderDto dto = new ReturnOrderDto();
        List terminalCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getTerminalCode).distinct().collect(Collectors.toList());
        List productCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getProductCode).distinct().collect(Collectors.toList());
        List tpmSystemCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getSystemCode).distinct().collect(Collectors.toList());
        List regions = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getRegion).distinct().collect(Collectors.toList());
        dto.setTerminalCodeList(terminalCodes);
        dto.setProductCodeList(productCodes);
        dto.setCustomerRetailerCodeList(tpmSystemCodes);
        dto.setAreaCodes(regions);
        List tpmReturnOrderVos = this.returnOrderVoService.tpmFindReturnGoodsByConditions(dto);
        log.info("TPM\u67e5\u8be2KMS\u9000\u8d27\u5355\u6570\u636e\u91cf{}", (Object)tpmReturnOrderVos.size());
        Map<Object, Object> returnMap = new HashMap();
        if (!CollectionUtil.isEmpty((Collection)tpmReturnOrderVos)) {
            returnMap = tpmReturnOrderVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getTpmSystemCode(), vo.getBusinessArea(), vo.getDeliveryPartyCode(), vo.getProductCode(), DateUtil.format((Date)vo.getOrderTime(), (String)"yyyy-MM")})));
        }
        Calendar calendar = Calendar.getInstance();
        Date startDay = DateUtil.getFirstDayOfMonth((Date)new Date());
        calendar.setTime(startDay);
        calendar.add(5, 7);
        Date oneDay = calendar.getTime();
        calendar.add(5, 7);
        Date twoDay = calendar.getTime();
        calendar.add(5, 7);
        Date threeDay = calendar.getTime();
        Date fourDay = DateUtil.getLastDayOfMonth((Date)new Date());
        ArrayList<ActivityReturnTransGiftEntity> entityList = new ArrayList<ActivityReturnTransGiftEntity>();
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        for (Map.Entry<String, List<ActivityDetailPlanItemVo>> item : groupPlanItemMap.entrySet()) {
            String key = item.getKey();
            List<ActivityDetailPlanItemVo> value = item.getValue();
            List tpmReturnOrderList = (List)returnMap.get(key);
            ActivityReturnTransGiftEntity entity = this.buildParam(key, value, tpmReturnOrderList, startDay, oneDay, twoDay, threeDay, fourDay, tenantCode, delFlag);
            entityList.add(entity);
        }
        ArrayList<ActivityReturnTransGiftEntity> saveList = new ArrayList<ActivityReturnTransGiftEntity>();
        ArrayList<ActivityReturnTransGiftEntity> updateList = new ArrayList<ActivityReturnTransGiftEntity>();
        List<String> collect = entityList.stream().map(ActivityReturnTransGiftEntity::getOnlyKey).distinct().collect(Collectors.toList());
        List<ActivityReturnTransGiftEntity> byOnlyKey = this.activityReturnTransGiftRepository.findByOnlyKey(collect);
        if (!CollectionUtil.isEmpty(byOnlyKey)) {
            Map<String, String> onlyKeyMap = byOnlyKey.stream().collect(Collectors.toMap(ActivityReturnTransGiftEntity::getOnlyKey, UuidEntity::getId));
            for (ActivityReturnTransGiftEntity entity : entityList) {
                if (onlyKeyMap.containsKey(entity.getOnlyKey())) {
                    String id = onlyKeyMap.get(entity.getOnlyKey());
                    entity.setId(id);
                    updateList.add(entity);
                    continue;
                }
                saveList.add(entity);
            }
        } else {
            saveList.addAll(entityList);
        }
        if (!CollectionUtil.isEmpty(saveList)) {
            this.activityReturnTransGiftRepository.saveBatch(saveList);
        }
        if (!CollectionUtil.isEmpty(updateList)) {
            this.activityReturnTransGiftRepository.updateBatchById(updateList);
        }
    }

    private ActivityReturnTransGiftEntity buildParam(String key, List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList, List<TpmReturnOrderVo> tpmReturnOrderVoList, Date startDay, Date oneDay, Date twoDay, Date threeDay, Date fourDay, String tenantCode, String delFlag) {
        ActivityReturnTransGiftEntity entity = new ActivityReturnTransGiftEntity();
        ActivityDetailPlanItemVo activityDetailPlanItemVo = activityDetailPlanItemVoList.get(0);
        entity.setOnlyKey(key);
        BigDecimal mountReturnAmount = BigDecimal.ZERO;
        BigDecimal monthReturnNum = BigDecimal.ZERO;
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal oneAmount = BigDecimal.ZERO;
        BigDecimal twoAmount = BigDecimal.ZERO;
        BigDecimal threeAmount = BigDecimal.ZERO;
        BigDecimal fourAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(tpmReturnOrderVoList)) {
            for (TpmReturnOrderVo tpmReturnOrderVo : tpmReturnOrderVoList) {
                mountReturnAmount = mountReturnAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                monthReturnNum = monthReturnNum.add(Optional.ofNullable(tpmReturnOrderVo.getCurCompanyUnitOrderQuantity()).orElse(BigDecimal.ZERO).abs());
                if (startDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(oneDay) < 0) {
                    oneAmount = oneAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                    continue;
                }
                if (oneDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(twoDay) < 0) {
                    twoAmount = twoAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                    continue;
                }
                if (twoDay.compareTo(tpmReturnOrderVo.getOrderTime()) <= 0 && tpmReturnOrderVo.getOrderTime().compareTo(threeDay) < 0) {
                    threeAmount = threeAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
                    continue;
                }
                if (threeDay.compareTo(tpmReturnOrderVo.getOrderTime()) > 0 || tpmReturnOrderVo.getOrderTime().compareTo(fourDay) > 0) continue;
                fourAmount = fourAmount.add(Optional.ofNullable(tpmReturnOrderVo.getReturnAmount()).orElse(BigDecimal.ZERO).abs());
            }
        }
        for (ActivityDetailPlanItemVo detailPlanItemVo : activityDetailPlanItemVoList) {
            applyAmount = applyAmount.add(Optional.ofNullable(detailPlanItemVo.getFeeAmount()).orElse(BigDecimal.ZERO).abs());
            if (!Objects.nonNull(detailPlanItemVo.getPeriodPromotionalNumber())) continue;
            quantity = quantity.add(new BigDecimal(detailPlanItemVo.getPeriodPromotionalNumber()));
        }
        entity.setYearAndMonth(DateUtil.format((Date)activityDetailPlanItemVo.getActivityBeginDate(), (String)"yyyy-MM"));
        entity.setBusinessFormatCode(activityDetailPlanItemVo.getBusinessFormatCode());
        entity.setBusinessUnitCode(activityDetailPlanItemVo.getBusinessUnitCode());
        entity.setSystemCode(activityDetailPlanItemVo.getSystemCode());
        entity.setSystemName(activityDetailPlanItemVo.getSystemName());
        entity.setRegion(activityDetailPlanItemVo.getRegion());
        entity.setRegionName(activityDetailPlanItemVo.getRegionName());
        entity.setTerminalCode(activityDetailPlanItemVo.getTerminalCode());
        entity.setTerminalName(activityDetailPlanItemVo.getTerminalName());
        entity.setProductCode(activityDetailPlanItemVo.getProductCode());
        entity.setProductName(activityDetailPlanItemVo.getProductName());
        entity.setMonthReturnAmount(mountReturnAmount);
        entity.setMonthReturnNum(monthReturnNum);
        entity.setApplyAmount(applyAmount);
        entity.setQuantity(quantity);
        entity.setMonthDifferAmount(entity.getMonthReturnAmount().subtract(entity.getApplyAmount()));
        entity.setMonthDifferNum(entity.getMonthReturnNum().subtract(entity.getQuantity()));
        entity.setOneAmount(oneAmount);
        entity.setTwoAmount(twoAmount);
        entity.setThreeAmount(threeAmount);
        entity.setFourAmount(fourAmount);
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(delFlag);
        if (null != entity.getApplyAmount() && BigDecimal.ZERO.compareTo(entity.getApplyAmount()) != 0) {
            entity.setMonthAmountRate(entity.getMonthReturnAmount().divide(entity.getApplyAmount(), 6, 4));
        } else {
            entity.setMonthAmountRate(BigDecimal.ZERO);
        }
        return entity;
    }
}

