/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.BudgetUseFormEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.BudgetUseFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormAsyncService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BudgetUseFormAsyncServiceImpl
implements BudgetUseFormAsyncService {
    private static final Logger log = LoggerFactory.getLogger(BudgetUseFormAsyncServiceImpl.class);
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private BudgetUseFormRepository budgetUseFormRepository;
    @Autowired(required=false)
    private SalesGoalService salesGoalServicel;

    @Override
    @Async
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void saveData(List<String> keys, Map<String, List<MonthBudgetVo>> monthBudgetMap, String tenantCode, String delCode, Map<String, List<YearBudgetVo>> yearBudgetVoMap, String date) {
        ArrayList<BudgetUseFormEntity> budgetUseFormEntityList = new ArrayList<BudgetUseFormEntity>();
        for (String string : keys) {
            List<MonthBudgetVo> list = monthBudgetMap.get(string);
            Map<String, List<MonthBudgetVo>> monthItemBudgetMap = list.stream().collect(Collectors.groupingBy(vo -> StringUtils.join((Object[])new String[]{vo.getYearMonthLy(), vo.getRegionCode(), vo.getSystemCode(), vo.getBudgetItemCode()})));
            for (String s : monthItemBudgetMap.keySet()) {
                List<MonthBudgetVo> monthVo = monthItemBudgetMap.get(s);
                BudgetUseFormEntity budgetUseFormEntity = this.buildMonthParam(s, monthVo, tenantCode, delCode, date);
                budgetUseFormEntityList.add(budgetUseFormEntity);
            }
        }
        if (!CollectionUtils.isEmpty(budgetUseFormEntityList)) {
            Map<String, List<BudgetUseFormEntity>> yearBudgetUseMap = budgetUseFormEntityList.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)vo.getRegionCode(), (Object[])new Object[]{vo.getSystemCode(), vo.getBudgetItemCode()})));
            budgetUseFormEntityList.clear();
            for (Map.Entry<String, List<BudgetUseFormEntity>> entry : yearBudgetUseMap.entrySet()) {
                List<BudgetUseFormEntity> value = entry.getValue();
                List<BudgetUseFormEntity> budgetUseFormEntities = this.buildYearParam(value, yearBudgetVoMap, date);
                budgetUseFormEntityList.addAll(budgetUseFormEntities);
            }
        }
        List<String> onlyKeys = budgetUseFormEntityList.stream().map(BudgetUseFormEntity::getOnlyKey).distinct().collect(Collectors.toList());
        List<BudgetUseFormEntity> list = this.budgetUseFormRepository.findByOnlyKey(onlyKeys);
        ArrayList<BudgetUseFormEntity> arrayList = new ArrayList<BudgetUseFormEntity>();
        ArrayList<BudgetUseFormEntity> saveList = new ArrayList<BudgetUseFormEntity>();
        if (CollectionUtils.isEmpty(list)) {
            saveList.addAll(budgetUseFormEntityList);
        } else {
            Map<String, String> entityMap = list.stream().collect(Collectors.toMap(BudgetUseFormEntity::getOnlyKey, UuidEntity::getId, (a, b) -> a));
            for (BudgetUseFormEntity budgetUseFormEntity : budgetUseFormEntityList) {
                if (entityMap.containsKey(budgetUseFormEntity.getOnlyKey())) {
                    String id = entityMap.get(budgetUseFormEntity.getOnlyKey());
                    budgetUseFormEntity.setId(id);
                    arrayList.add(budgetUseFormEntity);
                    continue;
                }
                saveList.add(budgetUseFormEntity);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.budgetUseFormRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            this.budgetUseFormRepository.updateBatchById(arrayList);
        }
    }

    private BudgetUseFormEntity buildMonthParam(String key, List<MonthBudgetVo> monthBudgetVoList, String tenantCode, String delCode, String date) {
        BudgetUseFormEntity budgetUseFormEntity = new BudgetUseFormEntity();
        MonthBudgetVo monthBudgetVo = monthBudgetVoList.get(0);
        budgetUseFormEntity.setId(null);
        budgetUseFormEntity.setOnlyKey(key);
        budgetUseFormEntity.setYearAndMonth(monthBudgetVo.getYearMonthLy());
        budgetUseFormEntity.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
        budgetUseFormEntity.setBudgetItemName(monthBudgetVo.getBudgetItemName());
        budgetUseFormEntity.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
        budgetUseFormEntity.setRegionCode(monthBudgetVo.getRegionCode());
        budgetUseFormEntity.setRegionName(monthBudgetVo.getRegionName());
        budgetUseFormEntity.setSystemCode(monthBudgetVo.getSystemCode());
        budgetUseFormEntity.setSystemName(monthBudgetVo.getSystemName());
        budgetUseFormEntity.setBusinessFormatCode(monthBudgetVo.getBusinessFormatCode());
        budgetUseFormEntity.setBusinessUnitCode(monthBudgetVo.getBusinessUnitCode());
        budgetUseFormEntity.setTenantCode(tenantCode);
        budgetUseFormEntity.setDelFlag(delCode);
        BigDecimal monthBudgetAmount = BigDecimal.ZERO;
        SalesPerformanceDto salesPerformanceDto = new SalesPerformanceDto();
        salesPerformanceDto.setRegion(monthBudgetVo.getRegionName());
        salesPerformanceDto.setRetailer(monthBudgetVo.getSystemName());
        salesPerformanceDto.setSalesDate(monthBudgetVo.getYearMonthLy());
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        salesPlanDto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
        salesPlanDto.setRegionCode(monthBudgetVo.getRegionCode());
        salesPlanDto.setSystemCode(monthBudgetVo.getSystemCode());
        budgetUseFormEntity.setAcSaleAmount(Optional.ofNullable(this.salesPerformanceVoService.findSalesAmount(salesPerformanceDto)).orElse(BigDecimal.ZERO));
        budgetUseFormEntity.setPlanSaleAmount(Optional.ofNullable(this.salesPlanService.findSaleAmount(salesPlanDto)).orElse(BigDecimal.ZERO));
        BigDecimal monthUseAmount = BigDecimal.ZERO;
        for (MonthBudgetVo budgetVo : monthBudgetVoList) {
            monthBudgetAmount = monthBudgetAmount.add(Optional.ofNullable(budgetVo.getFirstReplyAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetVo.getActualReplyDiff()).orElse(BigDecimal.ZERO)));
            monthUseAmount = monthUseAmount.add(Optional.ofNullable(budgetVo.getApprovedAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetVo.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(budgetVo.getApprovedAuditDiff()).orElse(BigDecimal.ZERO))));
        }
        budgetUseFormEntity.setMonthBudgetAmount(monthBudgetAmount);
        budgetUseFormEntity.setMonthUsedAmount(monthUseAmount);
        BigDecimal monthBudgetTotalPoint = BigDecimal.ZERO;
        if (date.equals(monthBudgetVo.getYearMonthLy())) {
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getPlanSaleAmount()) != 0) {
                monthBudgetTotalPoint = monthBudgetTotalPoint.add(monthBudgetAmount.divide(budgetUseFormEntity.getPlanSaleAmount(), 6, 4));
            }
        } else if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getAcSaleAmount()) != 0) {
            monthBudgetTotalPoint = monthBudgetTotalPoint.add(monthBudgetAmount.divide(budgetUseFormEntity.getAcSaleAmount(), 6, 4));
        }
        budgetUseFormEntity.setMonthBudgetTotalPoint(monthBudgetTotalPoint);
        BigDecimal monthFeeRatio = BigDecimal.ZERO;
        if (budgetUseFormEntity.getAcSaleAmount().compareTo(budgetUseFormEntity.getPlanSaleAmount()) >= 0) {
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getAcSaleAmount()) != 0) {
                monthFeeRatio = monthUseAmount.divide(budgetUseFormEntity.getAcSaleAmount(), 6, 4);
            }
        } else if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getPlanSaleAmount()) != 0) {
            monthFeeRatio = monthUseAmount.divide(budgetUseFormEntity.getPlanSaleAmount(), 6, 4);
        }
        budgetUseFormEntity.setMonthFeeRatio(monthFeeRatio);
        budgetUseFormEntity.setMonthOverExpendAmount(budgetUseFormEntity.getMonthUsedAmount().subtract(budgetUseFormEntity.getMonthBudgetAmount()));
        BigDecimal monthOverExpendTotalPoint = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getMonthBudgetAmount()) != 0) {
            monthOverExpendTotalPoint = monthOverExpendTotalPoint.add(budgetUseFormEntity.getMonthOverExpendAmount().divide(budgetUseFormEntity.getMonthBudgetAmount(), 6, 4));
        }
        budgetUseFormEntity.setMonthOverExpendPoint(monthOverExpendTotalPoint);
        if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getMonthOverExpendAmount()) <= 0) {
            budgetUseFormEntity.setWarnType("\u9884\u8b66");
        } else {
            budgetUseFormEntity.setWarnType("\u6b63\u5e38");
        }
        return budgetUseFormEntity;
    }

    private List<BudgetUseFormEntity> buildYearParam(List<BudgetUseFormEntity> budgetUseFormEntityList, Map<String, List<YearBudgetVo>> yearBudgetVoMap, String nowDate) {
        for (BudgetUseFormEntity budgetUseFormEntity : budgetUseFormEntityList) {
            String yearMonth = budgetUseFormEntity.getYearAndMonth();
            BigDecimal budgetAmount = Optional.ofNullable(budgetUseFormEntity.getMonthBudgetAmount()).orElse(BigDecimal.ZERO);
            BigDecimal acItemSaleAmount = Optional.ofNullable(budgetUseFormEntity.getAcSaleAmount()).orElse(BigDecimal.ZERO);
            BigDecimal planItemSaleAmount = Optional.ofNullable(budgetUseFormEntity.getPlanSaleAmount()).orElse(BigDecimal.ZERO);
            BigDecimal overExpendAmount = Optional.ofNullable(budgetUseFormEntity.getMonthOverExpendAmount()).orElse(BigDecimal.ZERO);
            BigDecimal useAmount = Optional.ofNullable(budgetUseFormEntity.getMonthUsedAmount()).orElse(BigDecimal.ZERO);
            String systemCode = budgetUseFormEntity.getSystemCode();
            String regionCode = budgetUseFormEntity.getRegionCode();
            String budgetItemCode = budgetUseFormEntity.getBudgetItemCode();
            List lowYearList = budgetUseFormEntityList.stream().filter(vo -> yearMonth.compareTo(vo.getYearAndMonth()) > 0).collect(Collectors.toList());
            for (BudgetUseFormEntity lowYearEntity : lowYearList) {
                budgetAmount = budgetAmount.add(Optional.ofNullable(lowYearEntity.getMonthBudgetAmount()).orElse(BigDecimal.ZERO));
                planItemSaleAmount = planItemSaleAmount.add(Optional.ofNullable(lowYearEntity.getPlanSaleAmount()).orElse(BigDecimal.ZERO));
                acItemSaleAmount = acItemSaleAmount.add(Optional.ofNullable(lowYearEntity.getAcSaleAmount()).orElse(BigDecimal.ZERO));
                useAmount = useAmount.add(Optional.ofNullable(lowYearEntity.getMonthUsedAmount()).orElse(BigDecimal.ZERO));
                overExpendAmount = overExpendAmount.add(Optional.ofNullable(lowYearEntity.getMonthOverExpendAmount()).orElse(BigDecimal.ZERO));
            }
            budgetUseFormEntity.setBudgetAmount(budgetAmount);
            budgetUseFormEntity.setOverExpendAmount(overExpendAmount);
            budgetUseFormEntity.setUsedAmount(useAmount);
            if (yearMonth.equals(nowDate)) {
                BigDecimal saleAmount = acItemSaleAmount.subtract(budgetUseFormEntity.getAcSaleAmount()).add(budgetUseFormEntity.getPlanSaleAmount());
                if (BigDecimal.ZERO.compareTo(saleAmount) != 0) {
                    budgetUseFormEntity.setBudgetTotalPoint(budgetAmount.divide(saleAmount, 6, 4));
                } else {
                    budgetUseFormEntity.setBudgetTotalPoint(BigDecimal.ZERO);
                }
            } else if (BigDecimal.ZERO.compareTo(acItemSaleAmount) != 0) {
                budgetUseFormEntity.setBudgetTotalPoint(budgetAmount.divide(acItemSaleAmount, 6, 4));
            } else {
                budgetUseFormEntity.setBudgetTotalPoint(BigDecimal.ZERO);
            }
            if (yearMonth.equals(nowDate)) {
                if (acItemSaleAmount.compareTo(planItemSaleAmount) >= 0 && BigDecimal.ZERO.compareTo(acItemSaleAmount) != 0) {
                    budgetUseFormEntity.setFeeRatio(useAmount.divide(acItemSaleAmount, 6, 4));
                } else if (acItemSaleAmount.compareTo(planItemSaleAmount) < 0 && BigDecimal.ZERO.compareTo(planItemSaleAmount) != 0) {
                    budgetUseFormEntity.setFeeRatio(useAmount.divide(planItemSaleAmount, 6, 4));
                } else {
                    budgetUseFormEntity.setFeeRatio(BigDecimal.ZERO);
                }
            } else if (BigDecimal.ZERO.compareTo(acItemSaleAmount) != 0) {
                budgetUseFormEntity.setFeeRatio(useAmount.divide(acItemSaleAmount, 6, 4));
            } else {
                budgetUseFormEntity.setFeeRatio(BigDecimal.ZERO);
            }
            BigDecimal budgetTotalPoint = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(budgetUseFormEntity.getBudgetAmount()) != 0) {
                budgetTotalPoint = budgetTotalPoint.add(budgetUseFormEntity.getOverExpendAmount().divide(budgetUseFormEntity.getBudgetAmount(), 6, 4));
            }
            budgetUseFormEntity.setOverExpendPoint(budgetTotalPoint);
            List yearBudgetVos = Optional.ofNullable(yearBudgetVoMap.get(StringUtils.join((Object[])new String[]{systemCode, regionCode, budgetItemCode}))).orElse(new ArrayList());
            if (!CollectionUtils.isEmpty((Collection)yearBudgetVos)) {
                yearBudgetVos = yearBudgetVos.stream().distinct().collect(Collectors.toList());
            }
            BigDecimal budgetTotalAmount = BigDecimal.ZERO;
            for (YearBudgetVo yearBudgetVo : yearBudgetVos) {
                budgetTotalAmount = budgetTotalAmount.add(Optional.ofNullable(yearBudgetVo.getBudgetTotalAmount()).orElse(BigDecimal.ZERO));
            }
            if (BigDecimal.ZERO.compareTo(budgetTotalAmount) != 0) {
                budgetUseFormEntity.setBudgetUseProgress(budgetUseFormEntity.getUsedAmount().divide(budgetTotalAmount, 6, 4));
            } else {
                budgetUseFormEntity.setBudgetUseProgress(BigDecimal.ZERO);
            }
            SalesGoalDto dto = new SalesGoalDto();
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setYearMonthLy(yearMonth);
            dto.setSystemCode(systemCode);
            dto.setRegionCode(regionCode);
            dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            dto.setStartYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM").substring(0, 4) + "-01");
            BigDecimal discountAfter = Optional.ofNullable(this.salesGoalServicel.findDiscountAfter(dto)).orElse(BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(discountAfter) != 0) {
                if (yearMonth.equals(nowDate)) {
                    BigDecimal saleAmount = acItemSaleAmount.subtract(budgetUseFormEntity.getAcSaleAmount().add(budgetUseFormEntity.getPlanSaleAmount()));
                    budgetUseFormEntity.setSaleProgress(saleAmount.divide(discountAfter, 6, 4));
                } else {
                    budgetUseFormEntity.setSaleProgress(acItemSaleAmount.divide(discountAfter, 6, 4));
                }
            } else {
                budgetUseFormEntity.setSaleProgress(BigDecimal.ZERO);
            }
            budgetUseFormEntity.setVsSaleProgress(budgetUseFormEntity.getBudgetUseProgress().subtract(budgetUseFormEntity.getSaleProgress()));
        }
        return budgetUseFormEntityList;
    }
}

