/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormAsyncService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.BudgetUseFormService;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="BudgetUseFormService")
public class BudgetUseFormServiceImpl
implements BudgetUseFormService {
    private static final Logger log = LoggerFactory.getLogger(BudgetUseFormServiceImpl.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private BudgetUseFormAsyncService budgetUseFormAsyncService;

    @Override
    public void createOrUpdateData(List<String> codes) {
        String nowDate = DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)new Date());
        String tenantCode = TenantUtils.getTenantCode();
        String delCode = DelFlagStatusEnum.NORMAL.getCode();
        MonthBudgetDto dto = new MonthBudgetDto();
        List listByConditions = new ArrayList();
        if (CollectionUtils.isEmpty(codes)) {
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setDelFlag(delCode);
            dto.setEnableStatus(delCode);
            dto.setTenantCode(tenantCode);
            dto.setDateDown(nowDate);
            dto.setYear(nowDate.substring(0, 4));
            listByConditions = this.monthBudgetService.findListByConditions(dto);
        } else {
            dto.setBudgetItemCodeList(codes);
            listByConditions = this.monthBudgetService.findListByConditions(dto);
        }
        if (CollectionUtils.isEmpty(listByConditions)) {
            return;
        }
        log.info("\u672c\u6b21\u751f\u6210\u7684\u9884\u7b97\u4f7f\u7528\u6570\u636e\u91cf\u4e3a{}", (Object)listByConditions.size());
        List yearBudgetCode = listByConditions.stream().map(MonthBudgetVo::getYearBudgetCode).filter(vo -> StringUtils.isNotEmpty((CharSequence)vo)).distinct().collect(Collectors.toList());
        List yearBudgetList = this.yearBudgetSdkService.findYearBudgetByYearBudgetCodes(yearBudgetCode);
        HashMap<String, List<YearBudgetVo>> yearBudgetVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)yearBudgetList)) {
            yearBudgetVoMap = yearBudgetList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getSystemCode()) && StringUtils.isNotEmpty((CharSequence)vo.getRegionCode()) && StringUtils.isNotEmpty((CharSequence)vo.getBudgetItemCode())).collect(Collectors.groupingBy(vo -> StringUtils.join((Object[])new String[]{vo.getSystemCode(), vo.getRegionCode(), vo.getBudgetItemCode()})));
        }
        Map<String, List<MonthBudgetVo>> monthBudgetMap = listByConditions.stream().collect(Collectors.groupingBy(vo -> StringUtils.join((Object[])new String[]{vo.getRegionCode(), vo.getSystemCode(), vo.getBudgetItemCode()})));
        List collect = monthBudgetMap.keySet().stream().collect(Collectors.toList());
        log.info("\u6309\u7ef4\u5ea6\u6c47\u603b\u540e\u9884\u7b97\u4f7f\u7528\u6570\u636e\u91cf\u4e3a{}", (Object)collect.size());
        List partition = Lists.partition(collect, (int)2000);
        for (List strings : partition) {
            this.budgetUseFormAsyncService.saveData(strings, monthBudgetMap, tenantCode, delCode, yearBudgetVoMap, nowDate);
        }
    }
}

