/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataResultVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.vertical.form.table.local.entity.PriceMonitorFormEntity;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.PriceMonitorFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormAsyncService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="PriceMonitorFormAsyncService")
public class PriceMonitorFormAsyncServiceImpl
implements PriceMonitorFormAsyncService {
    private static final Logger log = LoggerFactory.getLogger(PriceMonitorFormAsyncServiceImpl.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private PriceMonitorFormRepository priceMonitorFormRepository;

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void asyncBuildPriceMonitorForm(Map<String, List<SalesDataResultVo>> posMap, Map<String, List<PriceVo>> priceMap, Map<String, ProductVo> productVosMap, List<String> activityFormCodes) {
        log.info("\u8fdb\u5165\u7ebf\u7a0b\u5f00\u59cb\u8fdb\u884c\u7ec6\u6848\u5339\u914d!");
        ArrayList<PriceMonitorFormEntity> entityList = new ArrayList<PriceMonitorFormEntity>();
        ArrayList<ActivityDetailPlanItemVo> planItemVoList = new ArrayList();
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        for (String key : posMap.keySet()) {
            List<SalesDataResultVo> salesDataResultVoList = posMap.get(key);
            SalesDataResultVo salesDataResultVo = salesDataResultVoList.get(0);
            log.info("pos\u5339\u914d\u6d3b\u52a8");
            ActivityDetailPlanItemDto czQueryDto = new ActivityDetailPlanItemDto();
            czQueryDto.setBusinessFormatCode(salesDataResultVo.getBusinessFormatCode());
            czQueryDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            czQueryDto.setTerminalCode(salesDataResultVo.getStoreCode());
            czQueryDto.setProductCode(salesDataResultVo.getGoodsCode());
            czQueryDto.setNowTime(salesDataResultVo.getSalesDate());
            planItemVoList = Optional.ofNullable(this.activityDetailPlanItemSdkService.findByConditionsList(czQueryDto)).orElse(new ArrayList());
            planItemVoList = planItemVoList.stream().filter(vo -> activityFormCodes.contains(vo.getActivityFormCode())).collect(Collectors.toList());
            PriceMonitorFormEntity entity = this.buildParam(salesDataResultVoList, planItemVoList, priceMap, key, tenantCode, delFlag, productVosMap);
            entityList.add(entity);
            planItemVoList.clear();
        }
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        List<String> onlyKeys = entityList.stream().map(PriceMonitorFormEntity::getOnlyKey).distinct().collect(Collectors.toList());
        List<PriceMonitorFormEntity> byOnlyKeys = this.priceMonitorFormRepository.findByOnlyKeys(onlyKeys);
        ArrayList<PriceMonitorFormEntity> saveList = new ArrayList<PriceMonitorFormEntity>();
        ArrayList<PriceMonitorFormEntity> updateList = new ArrayList<PriceMonitorFormEntity>();
        if (CollectionUtils.isEmpty(byOnlyKeys)) {
            saveList.addAll(entityList);
        } else {
            Map<String, String> map = byOnlyKeys.stream().collect(Collectors.toMap(PriceMonitorFormEntity::getOnlyKey, UuidEntity::getId, (newValue, oldValue) -> newValue));
            for (PriceMonitorFormEntity entity : entityList) {
                if (map.containsKey(entity.getOnlyKey())) {
                    String id = map.get(entity.getOnlyKey());
                    entity.setId(id);
                    updateList.add(entity);
                    continue;
                }
                saveList.add(entity);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.priceMonitorFormRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.priceMonitorFormRepository.updateBatchById(updateList);
        }
    }

    private PriceMonitorFormEntity buildParam(List<SalesDataResultVo> value, List<ActivityDetailPlanItemVo> planItemVoList, Map<String, List<PriceVo>> priceMap, String key, String tenantCode, String delFlag, Map<String, ProductVo> productVosMap) {
        ActivityDetailPlanItemVo activityDetailPlanItemVo;
        PriceMonitorFormEntity entity = new PriceMonitorFormEntity();
        SalesDataResultVo salesDataResultVo = value.get(0);
        entity.setId(null);
        entity.setOnlyKey(key);
        entity.setTenantCode(tenantCode);
        entity.setDelFlag(delFlag);
        entity.setSalesDate(salesDataResultVo.getSalesDate());
        entity.setSystemCode(salesDataResultVo.getDirectCode());
        entity.setSystemName(salesDataResultVo.getDirectName());
        entity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        entity.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        entity.setRegion(salesDataResultVo.getBusinessArea());
        entity.setKaStoreCode(salesDataResultVo.getKaStoreCode());
        entity.setTerminalCode(salesDataResultVo.getStoreCode());
        entity.setTerminalName(salesDataResultVo.getStoreName());
        entity.setProductCode(salesDataResultVo.getGoodsCode());
        entity.setProductName(salesDataResultVo.getGoodsName());
        entity.setUnitCode(salesDataResultVo.getMaxUnit());
        if (StringUtils.isNotEmpty((CharSequence)entity.getProductCode())) {
            ProductVo productVo = productVosMap.get(entity.getProductCode());
            entity.setBrandCode(productVo.getProductBrandCode());
            entity.setBrandName(productVo.getProductBrandName());
            entity.setProductItemName(productVo.getProductLevelName());
            entity.setProductItemCode(productVo.getProductLevelCode());
            entity.setProductCategoryName(productVo.getProductCategoryName());
            entity.setProductCategoryCode(productVo.getProductCategoryCode());
        }
        BigDecimal num = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal promotionDeduction = BigDecimal.ZERO;
        for (SalesDataResultVo dataResultVo : value) {
            num = num.add(Optional.ofNullable(dataResultVo.getCurUnitSalesQuantity()).orElse(BigDecimal.ZERO));
            amount = amount.add(Optional.ofNullable(dataResultVo.getSalesAmount()).orElse(BigDecimal.ZERO));
            promotionDeduction = promotionDeduction.add(Optional.ofNullable(dataResultVo.getPromotionDeduction()).orElse(BigDecimal.ZERO));
        }
        entity.setQuantity(num);
        entity.setQuantityWarn("300");
        entity.setSaleAmount(amount);
        if (BigDecimal.ZERO.compareTo(num) != 0) {
            entity.setTerminalPrice(amount.divide(num, 6, 4));
        } else {
            entity.setTerminalPrice(BigDecimal.ZERO);
        }
        if (!CollectionUtils.isEmpty(planItemVoList) && Objects.nonNull(activityDetailPlanItemVo = (ActivityDetailPlanItemVo)(planItemVoList = planItemVoList.stream().sorted(Comparator.comparing(ActivityDetailPlanItemBase::getSingleApplicationFee, Comparator.reverseOrder())).collect(Collectors.toList())).get(0))) {
            BigDecimal divide;
            if (StringUtil.isNotEmpty((String)activityDetailPlanItemVo.getSystemCode())) {
                entity.setSystemCode(activityDetailPlanItemVo.getSystemCode());
                entity.setSystemName(activityDetailPlanItemVo.getSystemName());
            }
            entity.setUnitCode(activityDetailPlanItemVo.getProductUnit());
            entity.setRegion(activityDetailPlanItemVo.getRegion());
            entity.setRegionName(activityDetailPlanItemVo.getRegionName());
            entity.setActivityCode(activityDetailPlanItemVo.getDetailPlanCode());
            entity.setActivityFormDesc(activityDetailPlanItemVo.getRemark());
            entity.setActivityFormCode(activityDetailPlanItemVo.getActivityFormCode());
            entity.setActivityFormName(activityDetailPlanItemVo.getActivityFormName());
            entity.setOriginalSupplyPrice(Optional.ofNullable(activityDetailPlanItemVo.getOriginalSupplyPrice()).orElse(BigDecimal.ZERO));
            entity.setApprovedPrice(activityDetailPlanItemVo.getPromotionalPrice());
            BigDecimal acSupplyPrice = BigDecimal.ZERO;
            BigDecimal onePromotionDeduction = BigDecimal.ZERO;
            if (null != num && BigDecimal.ZERO.compareTo(num) != 0) {
                onePromotionDeduction = onePromotionDeduction.add(Optional.ofNullable(promotionDeduction.divide(num, 6, 4)).orElse(BigDecimal.ZERO));
            }
            acSupplyPrice = entity.getOriginalSupplyPrice().subtract(onePromotionDeduction);
            entity.setAcSupplyPrice(acSupplyPrice);
            List<PriceVo> priceVos = priceMap.get(entity.getProductCode());
            if (!CollectionUtils.isEmpty(priceVos)) {
                entity.setRedPriceOne(Optional.ofNullable(priceVos.stream().max(Comparator.comparing(PriceVo::getPrice)).map(PriceVo::getPrice).get()).orElse(BigDecimal.ZERO));
                entity.setRedPriceTwo(Optional.ofNullable(priceVos.stream().min(Comparator.comparing(PriceVo::getPrice)).map(PriceVo::getPrice).get()).orElse(BigDecimal.ZERO));
            }
            if (null != entity.getOriginalSupplyPrice() && null != entity.getApprovedPrice() && BigDecimal.ZERO.compareTo(entity.getApprovedPrice()) != 0) {
                divide = entity.getOriginalSupplyPrice().divide(entity.getApprovedPrice(), 6, 4);
                entity.setPromotionalGross(BigDecimal.ONE.subtract(divide));
            }
            if (null != entity.getAcSupplyPrice() && null != entity.getTerminalPrice() && BigDecimal.ZERO.compareTo(entity.getTerminalPrice()) != 0 && BigDecimal.ZERO.compareTo(entity.getAcSupplyPrice()) != 0) {
                divide = entity.getAcSupplyPrice().divide(entity.getTerminalPrice(), 6, 4);
                entity.setAcPromotionalGross(BigDecimal.ONE.subtract(divide));
            } else {
                entity.setAcPromotionalGross(BigDecimal.ZERO);
            }
            BigDecimal singleApplicationFee = Optional.ofNullable(activityDetailPlanItemVo.getSingleApplicationFee()).orElse(BigDecimal.ZERO);
            if (Objects.nonNull(entity.getRedPriceTwo()) && singleApplicationFee.compareTo(entity.getRedPriceTwo()) <= 0) {
                entity.setPriceWarn("1");
            }
            if (Objects.nonNull(entity.getRedPriceTwo()) && Objects.nonNull(entity.getRedPriceOne()) && entity.getRedPriceTwo().compareTo(singleApplicationFee) < 0 && singleApplicationFee.compareTo(entity.getRedPriceOne()) <= 0) {
                entity.setPriceWarn("2");
            }
            if (Objects.nonNull(entity.getRedPriceOne()) && entity.getRedPriceOne().compareTo(singleApplicationFee) < 0) {
                entity.setPriceWarn("3");
            }
            if (null == entity.getPriceWarn()) {
                entity.setPriceWarn("3");
            }
            if (null != entity.getAcPromotionalGross() && null != entity.getActivityFormCode() && null != entity.getPromotionalGross()) {
                if (entity.getAcPromotionalGross().compareTo(entity.getPromotionalGross()) > 0) {
                    entity.setGrossWarn("1");
                } else {
                    entity.setGrossWarn("3");
                }
            }
            if (null == entity.getGrossWarn()) {
                entity.setGrossWarn("3");
            }
        }
        return entity;
    }
}

