/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.TpmPullPosDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataResultVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.vertical.form.table.local.dto.UpdateQuantityWarnDto;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.PriceMonitorFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormAsyncService;
import com.biz.crm.tpm.business.vertical.form.table.local.service.PriceMonitorFormService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="priceMonitorFormService")
public class PriceMonitorFormServiceImpl
implements PriceMonitorFormService {
    private static final Logger log = LoggerFactory.getLogger(PriceMonitorFormServiceImpl.class);
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private PriceMonitorFormAsyncService priceMonitorFormAsyncService;
    @Autowired(required=false)
    private PriceVoService priceVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private PriceMonitorFormRepository priceMonitorFormRepository;

    @Override
    public void createOrUpdateData(TpmPullPosDto dto) {
        Page resultPage;
        SalesDataDto salesDataDto = new SalesDataDto();
        if (Objects.nonNull(dto)) {
            salesDataDto.setSalesDate(dto.getSaleDate());
            salesDataDto.setModifyDate(dto.getModifyDate());
            salesDataDto.setDirectCode(dto.getDirectCode());
            salesDataDto.setDirectName(dto.getDirectName());
            salesDataDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        } else {
            salesDataDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            salesDataDto.setModifyDate(DateUtil.format((Date)DateUtils.addDays((Date)new Date(), (int)-1), (String)"yyyy-MM-dd"));
        }
        List redLinePrice = Optional.ofNullable(this.dictDataVoService.findByDictTypeCode("red_line_price")).orElse(new ArrayList());
        List<String> redLinePriceType = redLinePrice.stream().map(DictDataVo::getDictCode).distinct().collect(Collectors.toList());
        long currentPage = 0L;
        PageRequest pageable = PageRequest.of((int)1, (int)200);
        log.info("=====>    \u4ef7\u683c\u76d1\u63a7\u6570\u636e start    <=====");
        do {
            resultPage = this.invoiceSalesDataVoService.pageFindKmsPosByConditions((Pageable)pageable, salesDataDto);
            currentPage = resultPage.getCurrent();
            pageable = pageable.next();
            if (currentPage == 1L) {
                log.info("=====>    \u4ef7\u683c\u76d1\u63a7\u6570\u636e[POS\u6570\u636e]\u603b\u6570\u636e\u91cf\u4e3a:{}    <=====", (Object)resultPage.getTotal());
            }
            log.info("=====>    \u4ef7\u683c\u76d1\u63a7\u6570\u636e\u9875\u7801[{}/{}]    <=====", (Object)currentPage, (Object)resultPage.getPages());
            List pageRecords = resultPage.getRecords();
            if (CollectionUtils.isEmpty((Collection)pageRecords)) {
                return;
            }
            this.matchedActivity(pageRecords, redLinePriceType);
        } while (resultPage.hasNext());
        log.info("=====>    \u4ef7\u683c\u76d1\u63a7\u6570\u636e end    <=====");
    }

    @Override
    public void updateQuantityWarn(UpdateQuantityWarnDto dto) {
        Validate.notEmpty((CharSequence)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getQuantityWarn(), (String)"\u9884\u8b66\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.priceMonitorFormRepository.updateQuantityWarn(dto);
    }

    private void matchedActivity(List<SalesDataResultVo> salesDataResultVoList, List<String> redLinePriceType) {
        if (CollectionUtils.isEmpty(salesDataResultVoList)) {
            return;
        }
        Map<String, List<SalesDataResultVo>> posMap = salesDataResultVoList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getSalesDate()) && StringUtils.isNotEmpty((CharSequence)vo.getStoreCode()) && StringUtils.isNotEmpty((CharSequence)vo.getGoodsCode())).collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getSalesDate(), vo.getStoreCode(), vo.getGoodsCode()})));
        log.info("\u672c\u6b21\u4ef7\u683c\u76d1\u63a7\u6570\u636e\u91cf\u4e3a:{}", (Object)posMap.keySet().size());
        if (MapUtils.isNotEmpty(posMap)) {
            HashMap<String, ProductVo> productVosMap = new HashMap<String, ProductVo>();
            List productCodeList = salesDataResultVoList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getGoodsCode())).map(SalesDataResultVo::getGoodsCode).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(productCodeList)) {
                ProductQueryDto productdto = new ProductQueryDto();
                productdto.setProductCodeList(productCodeList);
                List productVos = this.productVoService.findByQueryDto(productdto);
                if (!CollectionUtils.isEmpty((Collection)productVos)) {
                    productVosMap.putAll(productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (oldValue, newValue) -> newValue)));
                }
            }
            List goodsCodes = salesDataResultVoList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getGoodsCode())).map(SalesDataResultVo::getGoodsCode).distinct().collect(Collectors.toList());
            PriceDto priceDto = new PriceDto();
            priceDto.setTypeCodes(redLinePriceType);
            priceDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            priceDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            priceDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            priceDto.setGoodsCodes(goodsCodes);
            List priceVoList = Optional.ofNullable(this.priceVoService.findByPriceDtoRedLine(priceDto)).orElse(new ArrayList());
            HashMap<String, List<PriceVo>> priceMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)priceVoList)) {
                priceMap = priceVoList.stream().collect(Collectors.groupingBy(PriceVo::getGoodsCode));
            }
            List activityFormCodes = this.activityFormService.findActivityFormCodeFromPromotionsType(BusinessUnitEnum.VERTICAL.getCode(), VerticalActivityTypeEnum.promotions.getCode(), "2");
            this.priceMonitorFormAsyncService.asyncBuildPriceMonitorForm(posMap, priceMap, productVosMap, activityFormCodes);
        }
    }
}

