/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.ect.business.account.checking.dto.report.AcountPeriodReportDto;
import com.biz.crm.ect.business.account.checking.service.AccountPeriodReportVoService;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WarningEctAccountPeriodInnerFormRegisterAbstract
extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {
    public static final String monitoringTable = "ect_account_period_inner_form";
    @Autowired(required=false)
    private AccountPeriodReportVoService accountPeriodReportVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private DirectVoService directVoService;

    public String monitoringTable() {
        return monitoringTable;
    }

    public List<TpmWarningMonitoringVariable> variableList() {
        ArrayList variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("shopkeeper_code");
        tpmWarningMonitoringVariable.setVariableFieldName("\u7cfb\u7edf\u7f16\u7801");
        tpmWarningMonitoringVariable.setVariableQueryField("shopkeeper_code");
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("shopkeeper_name");
        tpmWarningMonitoringVariable.setVariableFieldName("\u7cfb\u7edf");
        tpmWarningMonitoringVariable.setVariableQueryField("shopkeeper_name");
        variableList.add(tpmWarningMonitoringVariable);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable2 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable2.setVariableField("area");
        tpmWarningMonitoringVariable2.setVariableFieldName("\u5927\u533a");
        tpmWarningMonitoringVariable2.setVariableQueryField("area");
        variableList.add(tpmWarningMonitoringVariable2);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable4 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable4.setVariableField("not_receivable_money_tax");
        tpmWarningMonitoringVariable4.setVariableFieldName("\u672a\u56de\u6b3e\u91d1\u989d");
        tpmWarningMonitoringVariable4.setVariableQueryField("not_receivable_money_tax");
        tpmWarningMonitoringVariable4.setIsGroup(Boolean.valueOf(true));
        tpmWarningMonitoringVariable4.setGroupScale(Integer.valueOf(0));
        variableList.add(tpmWarningMonitoringVariable4);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable5 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable5.setVariableField("receivable_over_days");
        tpmWarningMonitoringVariable5.setVariableFieldName("\u56de\u6b3e\u903e\u671f\u5929\u6570");
        tpmWarningMonitoringVariable5.setVariableQueryField("receivable_over_days");
        tpmWarningMonitoringVariable5.setIsGroup(Boolean.valueOf(true));
        tpmWarningMonitoringVariable5.setGroupScale(Integer.valueOf(0));
        variableList.add(tpmWarningMonitoringVariable5);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable6 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable6.setVariableField("not_ticket_money_tax");
        tpmWarningMonitoringVariable6.setVariableFieldName("\u672a\u56de\u7968\u91d1\u989d");
        tpmWarningMonitoringVariable6.setVariableQueryField("not_ticket_money_tax");
        tpmWarningMonitoringVariable6.setIsGroup(Boolean.valueOf(true));
        tpmWarningMonitoringVariable6.setGroupScale(Integer.valueOf(0));
        variableList.add(tpmWarningMonitoringVariable6);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable7 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable7.setVariableField("ticket_over_days");
        tpmWarningMonitoringVariable7.setVariableFieldName("\u56de\u7968\u903e\u671f\u5929\u6570");
        tpmWarningMonitoringVariable7.setVariableQueryField("ticket_over_days");
        tpmWarningMonitoringVariable7.setIsGroup(Boolean.valueOf(true));
        tpmWarningMonitoringVariable7.setGroupScale(Integer.valueOf(0));
        variableList.add(tpmWarningMonitoringVariable7);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable8 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable8.setVariableField("ticket_date");
        tpmWarningMonitoringVariable8.setVariableFieldName("\u5e94\u56de\u7968\u65e5\u671f");
        tpmWarningMonitoringVariable8.setVariableQueryField("ticket_date");
        variableList.add(tpmWarningMonitoringVariable8);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable9 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable9.setVariableField("receivable_date");
        tpmWarningMonitoringVariable9.setVariableFieldName("\u5e94\u56de\u6b3e\u65e5\u671f");
        tpmWarningMonitoringVariable9.setVariableQueryField("receivable_date");
        variableList.add(tpmWarningMonitoringVariable9);
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable10 = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable10.setVariableField("area_name");
        tpmWarningMonitoringVariable10.setVariableFieldName("\u533a\u57df\u540d\u79f0");
        tpmWarningMonitoringVariable10.setVariableQueryField("area_name");
        variableList.add(tpmWarningMonitoringVariable10);
        return variableList;
    }

    public List<Map<String, Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        List directVos;
        List systemCodeList;
        AcountPeriodReportDto dto = new AcountPeriodReportDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        dto.setQueryFlag("inner");
        List list = this.accountPeriodReportVoService.acountPeriodReportWarning(dto);
        Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        if (!CollectionUtils.isEmpty((Map)regionMap)) {
            for (int i = 0; i < list.size(); ++i) {
                Object businessAreaObj;
                Map stringObjectMap = (Map)list.get(i);
                if (!stringObjectMap.containsKey("area") || null == (businessAreaObj = stringObjectMap.get("area"))) continue;
                String businessAreaName = (String)regionMap.get(businessAreaObj.toString());
                stringObjectMap.put("area_name", businessAreaName);
                list.set(i, stringObjectMap);
            }
        }
        if (ObjectUtils.isNotEmpty(systemCodeList = list.stream().map(item -> item.get("shopkeeper_code")).filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.toList())) && ObjectUtils.isNotEmpty((Object)(directVos = this.directVoService.findByDirectCodes(systemCodeList)))) {
            Map<String, String> directMap = directVos.stream().collect(Collectors.toMap(DirectVo::getDirectCode, DirectVo::getCustomerRetailerCode, (o, n) -> n));
            for (int i = 0; i < list.size(); ++i) {
                Map objectMap = (Map)list.get(i);
                Object systemCodeObj = objectMap.get("shopkeeper_code");
                if (null == systemCodeObj) continue;
                String systemCode = systemCodeObj.toString();
                objectMap.put("shopkeeper_code", directMap.getOrDefault(systemCode, systemCode));
                list.set(i, objectMap);
            }
        }
        return list;
    }

    public String businessCodeField() {
        return "id";
    }

    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension) {
            case REGION: {
                return "area";
            }
            case SYSTEM: {
                return "shopkeeper_code";
            }
        }
        return null;
    }

    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension) {
            case REGION: {
                return Lists.newArrayList((Object[])new String[]{"area", "area_name"});
            }
            case SYSTEM: {
                return Lists.newArrayList((Object[])new String[]{"shopkeeper_code", "shopkeeper_name"});
            }
        }
        return Lists.newArrayList();
    }
}

