/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.vertical.form.table.local.service.impl;

import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.vertical.form.table.local.repository.PriceMonitorFormRepository;
import com.biz.crm.tpm.business.vertical.form.table.sdk.dto.PriceMonitorFormWarningQueryDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WarningPriceMonitorFormRegisterAbstract
extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {
    @Autowired(required=false)
    private PriceMonitorFormRepository priceMonitorFormRepository;
    public static final String monitoringTable = "tpm_price_monitor_form";
    public static final String FIELD_SYSTEM_CODE = "system_code";
    @Autowired(required=false)
    private DirectVoService directVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public String monitoringTable() {
        return monitoringTable;
    }

    public List<TpmWarningMonitoringVariable> variableList() {
        ArrayList variableList = com.google.common.collect.Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("currDay");
        tpmWarningMonitoringVariable.setVariableFieldName("\u5f53\u524d\u65e5\u671f");
        tpmWarningMonitoringVariable.setVariableQueryField("currDay");
        tpmWarningMonitoringVariable.setIsWaring(Boolean.valueOf(true));
        tpmWarningMonitoringVariable.setIsCondition(Boolean.valueOf(false));
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("region_name");
        tpmWarningMonitoringVariable.setVariableFieldName("\u533a\u57df");
        tpmWarningMonitoringVariable.setVariableQueryField("region_name");
        tpmWarningMonitoringVariable.setIsWaring(Boolean.valueOf(true));
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("system_name");
        tpmWarningMonitoringVariable.setVariableFieldName("\u7cfb\u7edf");
        tpmWarningMonitoringVariable.setVariableQueryField("system_name");
        tpmWarningMonitoringVariable.setIsWaring(Boolean.valueOf(true));
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("product_name");
        tpmWarningMonitoringVariable.setVariableFieldName("\u4ea7\u54c1\u540d\u79f0");
        tpmWarningMonitoringVariable.setVariableQueryField("product_name");
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("approved_price");
        tpmWarningMonitoringVariable.setVariableFieldName("\u6279\u590d\u4ef7\u5355\u4ef7");
        tpmWarningMonitoringVariable.setVariableQueryField("approved_price");
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("terminal_price");
        tpmWarningMonitoringVariable.setVariableFieldName("pos\u6210\u4ea4\u4ef7\u5355\u4ef7");
        tpmWarningMonitoringVariable.setVariableQueryField("terminal_price");
        variableList.add(tpmWarningMonitoringVariable);
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("red_price_one");
        tpmWarningMonitoringVariable.setVariableFieldName("\u7ea2\u7ebf\u4ef71");
        tpmWarningMonitoringVariable.setVariableQueryField("red_price_one");
        variableList.add(tpmWarningMonitoringVariable);
        return variableList;
    }

    public List<Map<String, Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        List directVos;
        PriceMonitorFormWarningQueryDto dto = new PriceMonitorFormWarningQueryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        List<Map<String, Object>> list = this.priceMonitorFormRepository.findPriceMonitorFormWarning(dto);
        ArrayList dictCodeList = com.google.common.collect.Lists.newArrayList((Object[])new String[]{"MDM_CUSTOMIZE_ORG"});
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
        HashMap dictMapMap = !CollectionUtils.isEmpty((Map)dictMap) ? dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n)) : new HashMap();
        Map regionMap = (Map)dictMapMap.get("MDM_CUSTOMIZE_ORG");
        String currDay = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd");
        for (Map<String, Object> stringObjectMap : list) {
            stringObjectMap.put("currDay", currDay);
            Object regionObj = stringObjectMap.get("region");
            if (null == regionObj) continue;
            stringObjectMap.put("region_name", regionMap.get(regionObj.toString()));
        }
        List systemCodeList = list.stream().map(item -> item.get(FIELD_SYSTEM_CODE)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(systemCodeList) && !CollectionUtils.isEmpty((Collection)(directVos = this.directVoService.findByDirectCodes(systemCodeList)))) {
            Map<String, String> directMap = directVos.stream().collect(Collectors.toMap(DirectVo::getDirectCode, DirectVo::getCustomerRetailerCode, (o, n) -> n));
            for (Map<String, Object> objectMap : list) {
                Object systemCodeObj = objectMap.get(FIELD_SYSTEM_CODE);
                if (null == systemCodeObj) continue;
                String systemCode = systemCodeObj.toString();
                objectMap.put(FIELD_SYSTEM_CODE, directMap.getOrDefault(systemCode, systemCode));
            }
        }
        return list;
    }

    public String businessCodeField() {
        return "id";
    }

    public List<String> defaultDimensionKey() {
        return com.google.common.collect.Lists.newArrayList((Object[])new String[]{"currDay"});
    }

    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension) {
            case REGION: {
                return "region";
            }
            case SYSTEM: {
                return FIELD_SYSTEM_CODE;
            }
        }
        return null;
    }

    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension) {
            case REGION: {
                return com.google.common.collect.Lists.newArrayList((Object[])new String[]{"region", "region_name"});
            }
            case SYSTEM: {
                return com.google.common.collect.Lists.newArrayList((Object[])new String[]{FIELD_SYSTEM_CODE, "system_name"});
            }
        }
        return Lists.newArrayList();
    }
}

