package com.biz.crm.tpm.business.warning.config.local.controller;


import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.warning.config.local.job.RefreshWarningMonitoringTask;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningConfigService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigDisplayVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.*;

/**
 * TPM-预警配置(TpmWarningConfig)表相关的http接口
 *
 * @author duyiran
 * @since 2022-11-03 15:44:38
 */
@RestController
@RequestMapping("/v1/tpmWarningConfig")
@Slf4j
@Api(tags = "TPM-预警配置")
public class TpmWarningConfigController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmWarningConfigService tpmWarningConfigService;

    @Autowired(required = false)
    private RefreshWarningMonitoringTask refreshWarningMonitoringTask;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询所有数据
     *
     * @param pageable         分页对象
     * @param tpmWarningConfig 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmWarningConfigVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "tpmWarningConfig", value = "TPM-预警配置") TpmWarningConfigDto tpmWarningConfig) {
        try {
            Page<TpmWarningConfigVo> page = this.tpmWarningConfigService.findByConditions(pageable, tpmWarningConfig);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据(前端用)
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据(前端用)")
    @GetMapping("{id}")
    public Result<TpmWarningConfigDisplayVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            TpmWarningConfigDisplayVo tpmWarningConfig = this.tpmWarningConfigService.findById(id);
            return Result.ok(tpmWarningConfig);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param tpmWarningConfig 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<TpmWarningConfigVo> create(@ApiParam(name = "tpmWarningConfig", value = "TPM-预警配置") @RequestBody TpmWarningConfigDto tpmWarningConfig) {
        try {
            TpmWarningConfigVo result = this.tpmWarningConfigService.create(tpmWarningConfig);

            String dayStr = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
            TpmWarningConfigDto tpmWarningConfigDto = nebulaToolkitService.copyObjectByWhiteList(result, TpmWarningConfigDto.class, HashSet.class, ArrayList.class);
            refreshWarningMonitoringTask.startNewtWarningMonitoring(dayStr,tpmWarningConfigDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param tpmWarningConfig 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<TpmWarningConfigVo> update(@ApiParam(name = "tpmWarningConfig", value = "TPM-预警配置") @RequestBody TpmWarningConfigDto tpmWarningConfig) {
        try {
            TpmWarningConfigVo result = this.tpmWarningConfigService.update(tpmWarningConfig);

            TpmWarningConfigDto tpmWarningConfigDto = nebulaToolkitService.copyObjectByWhiteList(result, TpmWarningConfigDto.class, HashSet.class, ArrayList.class);
            refreshWarningMonitoringTask.resetWarningMonitoring(tpmWarningConfigDto);

            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
        try {
            List<TpmWarningConfigVo> list = this.tpmWarningConfigService.delete(idList);

            Collection<TpmWarningConfigDto> tpmWarningConfigDtos = nebulaToolkitService.copyCollectionByWhiteList(list, TpmWarningConfigVo.class, TpmWarningConfigDto.class, HashSet.class, ArrayList.class);
            for (TpmWarningConfigDto tpmWarningConfigDto : tpmWarningConfigDtos) {
                refreshWarningMonitoringTask.resetWarningMonitoring(tpmWarningConfigDto);
            }

            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据业务编码启用
     */
    @PatchMapping("stopWarningMonitoringByTaskDesc")
    @ApiOperation(value = "停止预警监控任务")
    public Result stopWarningMonitoringByTaskDesc(@ApiParam(name = "taskDesc", value = "任务描述") @RequestParam String taskDesc){
        try {
            refreshWarningMonitoringTask.stopWarningMonitoringByTaskDesc(taskDesc);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}
