package com.biz.crm.tpm.business.warning.config.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.warning.config.local.service.TpmWarningMonitoringService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningConfigService;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigDisplayVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * TPM-监控表预警(TpmWarningConfig)表相关的http接口
 *
 */
@RestController
@RequestMapping("/v1/tpmWarningMonitoring")
@Slf4j
@Api(tags = "TPM-预警配置")
public class TpmWarningMonitoringController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmWarningMonitoringService tpmWarningMonitoringService;

    @ApiOperation(value = "查询监控表变量")
    @GetMapping("findTpmWarningMonitoringVariableList")
    public Result<List<TpmWarningMonitoringVariable>> findTpmWarningMonitoringVariableList(String monitoringTable){
        try {
            Validate.notBlank(monitoringTable,"监控表不能为空！");
            List<TpmWarningMonitoringVariable> list = tpmWarningMonitoringService.findTpmWarningMonitoringVariableList(monitoringTable);
            return Result.ok(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询监控表变量-公式")
    @GetMapping("findTpmWarningMonitoringConditionVariableList")
    public Result<List<TpmWarningMonitoringVariable>> findTpmWarningMonitoringConditionVariableList(String monitoringTable){
        try {
            Validate.notBlank(monitoringTable,"监控表不能为空！");
            List<TpmWarningMonitoringVariable> list = tpmWarningMonitoringService.findTpmWarningMonitoringVariableList(monitoringTable);
            list = list.stream().filter(TpmWarningMonitoringVariable::getIsCondition).collect(Collectors.toList());
            return Result.ok(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询监控表变量-提示")
    @GetMapping("findTpmWarningMonitoringWarningVariableList")
    public Result<List<TpmWarningMonitoringVariable>> findTpmWarningMonitoringWarningVariableList(String monitoringTable){
        try {
            Validate.notBlank(monitoringTable,"监控表不能为空！");
            List<TpmWarningMonitoringVariable> list = tpmWarningMonitoringService.findTpmWarningMonitoringVariableList(monitoringTable);
            list = list.stream().filter(TpmWarningMonitoringVariable::getIsWaring).collect(Collectors.toList());
            return Result.ok(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "执行监控表预警")
    @GetMapping("runTpmWarningMonitoring")
    public Result runTpmWarningMonitoring(TpmWarningConfigDto dto){
        try {
            List<TpmWarningConfigDto> configDtos = tpmWarningMonitoringService.findRunTpmWarningMonitoring(dto);
            for (TpmWarningConfigDto configDto : configDtos) {
                try {
                    tpmWarningMonitoringService.runTpmWarningMonitoring(configDto);
                }catch (Exception e){
                    log.error("预警配置["+configDto.getCode()+"]执行失败!",e);
                }
            }
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据业务编码禁用
     */
    @PatchMapping("disable")
    @ApiOperation(value = "根据业务编码禁用")
    public Result disable( @ApiParam(name = "monitoringTable", value = "表") @RequestParam String monitoringTable,
            @ApiParam(name = "businessCodeList", value = "主键集合") @RequestBody List<String> businessCodeList){
        try {
            tpmWarningMonitoringService.disable(monitoringTable,businessCodeList);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据业务编码启用
     */
    @PatchMapping("enable")
    @ApiOperation(value = "根据业务编码启用")
    public Result enable(@ApiParam(name = "monitoringTable", value = "表") @RequestParam String monitoringTable,
                         @ApiParam(name = "businessCodeList", value = "主键集合") @RequestBody List<String> businessCodeList){
        try {
            tpmWarningMonitoringService.enable(monitoringTable,businessCodeList);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}
