package com.biz.crm.tpm.business.warning.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 预警配置-条件子表
 * @author duyiran
 * @create 2022-11-04 10:24
 */
@Data
@TableName("tpm_warning_condition")
@Entity(name = "tpm_warning_condition")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmWarningCondition", description = "TPM-预警配置-条件子表")
@org.hibernate.annotations.Table(appliesTo = "tpm_warning_condition", comment = "TPM-预警配置-条件子表")
@Table(name = "tpm_warning_condition", indexes = {@Index(name = "tpm_warning_condition_index1", columnList = "tenant_code, code, sub_code", unique = true)})
public class TpmWarningCondition extends TenantFlagOpEntity {

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String code;

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "sub_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String subCode;

    /**
     * 预警条件公式
     */
    @ApiModelProperty(name = "预警条件公式", notes = "预警条件公式")
    @Column(name = "formula", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警条件公式'")
    private String formula;

    /**
     * 预警条件公式（展示用）
     */
    @ApiModelProperty(name = "预警条件公式（展示用）", notes = "预警条件公式（展示用）")
    @Column(name = "formula_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警条件公式（展示用）'")
    private String formulaName;

    /**
     * 预警级别[数据字典:tpm_warning_level]
     */
    @ApiModelProperty(name = "预警级别[数据字典:tpm_warning_level]", notes = "预警级别[数据字典:tpm_warning_level]")
    @Column(name = "warning_level", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警级别[数据字典:tpm_warning_level]'")
    private String warningLevel;

}
