package com.biz.crm.tpm.business.warning.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 预警配置主表
 *
 * @author duyiran
 * @create 2022-11-03 11:44
 */
@Data
@TableName("tpm_warning_config")
@Entity(name = "tpm_warning_config")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmWarningConfig", description = "TPM-预警配置主表")
@org.hibernate.annotations.Table(appliesTo = "tpm_warning_config", comment = "TPM-预警配置主表")
@Table(name = "tpm_warning_config", indexes = {@Index(name = "tpm_warning_config_index1", columnList = "tenant_code, code, activity_form_code", unique = true)})
public class TpmWarningConfig extends TenantFlagOpEntity {

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String code;

    /**
     * 预警规则名称
     */
    @ApiModelProperty(name = "预警规则名称", notes = "预警规则名称")
    @Column(name = "name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警规则名称'")
    private String name;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    /**
     * 推送维度[数据字典:tpm_warning_dimension]
     */
    @ApiModelProperty(name = "推送维度[数据字典:tpm_warning_dimension]", notes = "推送维度[数据字典:tpm_warning_dimension]")
    @Column(name = "push_dimension", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '推送维度[数据字典:tpm_warning_dimension]'")
    private String pushDimension;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    /**
     * 活动形式Code
     */
    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式Code'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 预警方式[数据字典:tpm_warning_mode]
     */
    @ApiModelProperty(name = "预警方式[数据字典:tpm_warning_mode]", notes = "预警方式[数据字典:tpm_warning_mode]")
    @Column(name = "warning_mode", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警方式[数据字典:tpm_warning_mode]'")
    private String warningMode;

    /**
     * 预警开始日期
     */
    @ApiModelProperty(name = "预警开始日期", notes = "预警开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "start_date", nullable = false, length = 10, columnDefinition = "datetime COMMENT '预警开始日期'")
    private Date startDate;

    /**
     * 预警结束日期
     */
    @ApiModelProperty(name = "预警结束日期", notes = "预警结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", nullable = false, length = 10, columnDefinition = "datetime COMMENT '预警结束日期'")
    private Date endDate;

    /**
     * 预警频率
     */
    @ApiModelProperty(name = "预警频率", notes = "预警频率")
    @Column(name = "warning_frequency", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '预警频率'")
    private String warningFrequency;

    /**
     * 监控表
     */
    @Column(name = "monitoring_table",length = 64, columnDefinition = "VARCHAR(64) COMMENT '监控表'")
    private String monitoringTable;

    /**
     * 推送内容
     */
    @Column(name = "push_content", length = 1024, columnDefinition = "VARCHAR(1024) COMMENT '推送内容'")
    private String pushContent;

    /**
     * 推送内容公式
     */
    @Column(name = "push_content_formula", length = 1024, columnDefinition = "VARCHAR(1024) COMMENT '推送内容公式'")
    private String pushContentFormula;

    /**
     * 是否重复推送
     */
    @Column(name = "repeat_push", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭，   Y是N否'")
    private String repeatPush;


}
