package com.biz.crm.tpm.business.warning.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 报表监控数据
 * @author wanghaojia
 * @date 2023/6/14 14:35
 */
@Data
@TableName("tpm_warning_monitoring")
@Entity(name = "tpm_warning_monitoring")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmWarningMonitoring", description = "TPM-预警日志")
@org.hibernate.annotations.Table(appliesTo = "tpm_warning_monitoring", comment = "TPM-预警日志")
@Table(name = "tpm_warning_monitoring", indexes = {
        @Index(name = "tpm_warning_monitoring_inx1", columnList = "warning_code", unique = false),
        @Index(name = "tpm_warning_monitoring_inx2", columnList = "tenant_code, business_code", unique = false),
        @Index(name = "tpm_warning_monitoring_inx3", columnList = "monitoring_table", unique = false)
})
public class TpmWarningMonitoring extends TenantFlagOpEntity {

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "warning_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String warningCode;

    /**
     * 预警规则名称
     */
    @ApiModelProperty(name = "预警规则名称", notes = "预警规则名称")
    @Column(name = "warning_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警规则名称'")
    private String warningName;

    /**
     * 监控表
     */
    @Column(name = "monitoring_table",length = 64, columnDefinition = "VARCHAR(64) COMMENT '监控表'")
    private String monitoringTable;

    /**
     * 业务编码
     */
    @ApiModelProperty(name = "业务编码", notes = "业务编码")
    @Column(name = "business_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务编码'")
    private String businessCode;

    /**
     * 推送预警次数
     */
    @ApiModelProperty(name = "推送预警次数", notes = "推送预警次数")
    @Column(name = "warning_count", length = 11, columnDefinition = "int(11) COMMENT '推送预警次数'")
    private Integer warningCount;

    /**
     * 预警状态
     */
    @ApiModelProperty(name = "预警状态", notes = "预警状态")
    @Column(name = "warning_status", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警状态'")
    private String warningStatus;

    /**
     * 预警指标数量
     */
    @ApiModelProperty(name = "预警指标数量", notes = "预警指标数量")
    @Column(name = "warning_variable_count", length = 11, columnDefinition = "int(11) COMMENT '预警指标数量'")
    private Integer warningVariableCount;

    /**
     * 恢复预警次数
     */
    @ApiModelProperty(name = "恢复预警次数", notes = "恢复预警次数")
    @Column(name = "recover_warning_count", length = 11, columnDefinition = "int(11) COMMENT '恢复预警次数'")
    private Integer recoverWarningCount;

}
