package com.biz.crm.tpm.business.warning.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 监控日志
 * @author wanghaojia
 * @date 2023/6/14 14:35
 */
@Data
@TableName("tpm_warning_monitoring_log")
@Entity(name = "tpm_warning_monitoring_log")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmWarningMonitoringLog", description = "TPM-预警日志")
@org.hibernate.annotations.Table(appliesTo = "tpm_warning_monitoring_log", comment = "TPM-预警日志")
@Table(name = "tpm_warning_monitoring_log", indexes = {
        @Index(name = "tpm_warning_monitoring_log_inx1", columnList = "warning_code", unique = false),
        @Index(name = "tpm_warning_monitoring_log_inx2", columnList = "tenant_code, business_code", unique = false)
})
public class TpmWarningMonitoringLog  extends TenantFlagOpEntity {

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "执行id", notes = "执行id")
    @Column(name = "run_uuid", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '执行id'")
    private String runUuid;

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "warning_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String warningCode;

    /**
     * 业务编码
     */
    @ApiModelProperty(name = "业务编码", notes = "业务编码")
    @Column(name = "business_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务编码'")
    private String businessCode;

    /**
     * 预警条件公式
     */
    @ApiModelProperty(name = "预警条件公式", notes = "预警条件公式")
    @Column(name = "formula", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警条件公式'")
    private String formula;

    /**
     * 预警条件公式（展示用）
     */
    @ApiModelProperty(name = "预警条件公式（展示用）", notes = "预警条件公式（展示用）")
    @Column(name = "formula_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警条件公式（展示用）'")
    private String formulaName;

    /**
     * 预警条件公式（展示用）
     */
    @ApiModelProperty(name = "预警条件值", notes = "预警条件值")
    @Column(name = "formula_value", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警条件值'")
    private String formulaValue;

}
