package com.biz.crm.tpm.business.warning.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 预警配置-预警对象子表
 * @author duyiran
 * @create 2022-11-04 10:24
 */
@Data
@TableName("tpm_warning_receiving_object")
@Entity(name = "tpm_warning_receiving_object")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmWarningReceivingObject", description = "TPM-预警配置-预警对象子表")
@org.hibernate.annotations.Table(appliesTo = "tpm_warning_receiving_object", comment = "TPM-预警配置-预警对象子表")
@Table(name = "tpm_warning_receiving_object", indexes = {@Index(name = "tpm_warning_receiving_object_index1", columnList = "tenant_code, code, sub_code", unique = true)})
public class TpmWarningReceivingObject extends TenantFlagOpEntity {

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String code;

    /**
     * 组织/职位编码
     */
    @ApiModelProperty(name = "组织/职位编码", notes = "组织/职位编码")
    @Column(name = "sub_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织/职位编码'")
    private String subCode;

    /**
     * 组织/职位名称
     */
    @ApiModelProperty(name = "组织/职位名称", notes = "组织/职位名称")
    @Column(name = "sub_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '组织/职位名称'")
    private String subName;

    /**
     * 预警对象类型[数据字典:tpm_warning_receiving_object_type]
     */
    @ApiModelProperty(name = "预警对象类型[数据字典:tpm_warning_receiving_object_type]", notes = "")
    @Column(name = "warning_receiving_object_type", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警对象类型[数据字典:tpm_warning_receiving_object_type]'")
    private String warningReceivingObjectType;

    /**
     * 是否包含[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "是否包含[数据字典:yesOrNo]", notes = "是否包含[数据字典:yesOrNo]")
    @Column(name = "is_contains", length = 1, columnDefinition = "CHAR(1) COMMENT '是否包含[数据字典:yesOrNo]'")
    private String isContains;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "区域编码")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码'")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "区域名称")
    @Column(name = "region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '区域名称'")
    private String regionName;


    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    @Column(name = "customer_retailer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    @Column(name = "customer_retailer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String customerRetailerName;


    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称w", notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;


    /**
     * 用户账号
     */
    @ApiModelProperty(name = "用户账号", notes = "用户账号")
    @Column(name = "user_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '用户账号'")
    private String userName;

    /**
     * 用户名
     */
    @ApiModelProperty(name = "用户名", notes = "用户名")
    @Column(name = "full_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '用户名'")
    private String fullName;

}
