package com.biz.crm.tpm.business.warning.config.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningConfig;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigExportsDto;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConditionVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigExportsVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningReceivingObjectVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TPM-预警配置(TpmWarningConfig)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-03 15:44:40
 */
public interface TpmWarningConfigMapper extends BaseMapper<TpmWarningConfig> {

    /**
     * 分页查询所有数据
     *
     * @param page             分页对象
     * @param tpmWarningConfig 查询实体
     * @return 所有数据
     */
    Page<TpmWarningConfigVo> findByConditions(@Param("page") Page<TpmWarningConfigVo> page, @Param("dto") TpmWarningConfigDto tpmWarningConfig);


    /**
     * 根据code查询预警条件
     *
     * @param code
     */
    List<TpmWarningConditionVo> findConditionsByCode(@Param("code") String code);

    /**
     * 根据code查询预警对象
     *
     * @param code
     */
    List<TpmWarningReceivingObjectVo> findReceivingObjectsByCode(@Param("code") String code);

    /**
     * 数据库验重 业态+业务单元+活动形式编码+销售组织+生效日期段
     * 为真验证通过
     *
     * @param dto Dto对象
     */
    List<TpmWarningConfigVo> repeatValidate(@Param("dto")TpmWarningConfigDto dto);

    /**
     * 获取匹配的数据总量
     *
     * @param dto
     * @return
     */
    Integer getExportTotal(@Param("dto")TpmWarningConfigExportsDto dto);

    /**
     * 获取导出数据
     *
     * @param dto
     * @return
     */
    List<TpmWarningConfigExportsVo> findData(@Param("dto")TpmWarningConfigExportsDto dto);

    List<TpmWarningConfigVo> findUnderWay();
}

