package com.biz.crm.tpm.business.warning.config.local.register;

import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoring;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningMonitoringRepository;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description 监控预警扩展
 * @Author xiaoyoujun
 * @Date 2023/2/8 上午10:02
 */
@Slf4j
@Component
public class TpmWaringMonitoringQueryInterceptor implements ExternalQueryInterceptor {

    //扩展字段
    private static final String field = "warning_status";

    @Autowired(required = false)
    private TpmWarningMonitoringRepository tpmWarningMonitoringRepository;

    @Override
    public String code() {
        return "tpm_waring_monitoring"+"_"+field;
    }

    @Override
    public String name() {
        return "监控预警-预警状态";
    }

    @Override
    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
        //查询结果
        List<Map<String, Object>> results = executeContent.getResults();
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        //数据处理
        String businessCodeField = "only_key";
        String monitoringTable = "tpm_up_expect_audit_amount_monitor";
        List<String> businessCodeList = results.stream().map(item -> {
            return Optional.ofNullable(item.get(businessCodeField)).orElse("").toString();
        }).collect(Collectors.toList());
        List<TpmWarningMonitoring> warningMonitoringList = tpmWarningMonitoringRepository.findByBusinessCodeList(monitoringTable, businessCodeList);
        Map<String, TpmWarningMonitoring> warningMonitoringMap = warningMonitoringList.stream().collect(Collectors.toMap(TpmWarningMonitoring::getBusinessCode, Function.identity()));
        List<Object[]> contents = Lists.newArrayList();
        for (Map<String, Object> item : results) {
            if (null == item){
                contents.add(null);
                continue;
            }
            String businessCode = Optional.ofNullable(item.get(businessCodeField)).orElse("").toString();
            TpmWarningMonitoring tpmWarningMonitoring = warningMonitoringMap.get(businessCode);
            contents.add(Lists.newArrayList(tpmWarningMonitoring.getWarningStatus()).toArray());
        }
        return contents;
    }
}
