package com.biz.crm.tpm.business.warning.config.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningConfigStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author duyiran
 * @create 2022-11-07 20:01
 */
@Component
@Slf4j
public class TpmWarningConfigRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_warning_config_data_view";
    }

    @Override
    public String desc() {
        return "TPM-预警配置主表";
    }

    @Override
    public String buildSql() {

        return "select t.*, " +
                "CASE " +
                "WHEN t.start_date > current_date() THEN '"  + TpmWarningConfigStatusEnum.NOTSTARTED.getCode() + "' " +
                "WHEN t.end_date < current_date() THEN '"  + TpmWarningConfigStatusEnum.HASENDED.getCode() + "' " +
                "ELSE '"  + TpmWarningConfigStatusEnum.UNDERWAY.getCode() + "' " +
                "END AS status " +
                "from tpm_warning_config t " +
                "where t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "and t.tenant_code = :tenantCode ";
    }

}
