package com.biz.crm.tpm.business.warning.config.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningCondition;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningConditionMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * TPM-预警配置-条件子表(TpmWarningCondition)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-05 11:14:06
 */
@Component
public class TpmWarningConditionRepository extends ServiceImpl<TpmWarningConditionMapper, TpmWarningCondition> {

    @Autowired(required = false)
    private TpmWarningConditionMapper tpmWarningConditionMapper;

    /**
     * 分页查询数据
     *
     * @param pageable            分页对象
     * @param tpmWarningCondition 实体对象
     * @return
     */
    public Page<TpmWarningCondition> findByConditions(Pageable pageable, TpmWarningCondition tpmWarningCondition) {
        Page<TpmWarningCondition> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmWarningConditionMapper.findByConditions(page, tpmWarningCondition);
    }

    /**
     * 根据code删除预警公式
     *
     * @param code       code
     * @param tenantCode 租户编号
     */
    public void removeByCode(String code, String tenantCode) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmWarningCondition::getCode, code)
                .eq(TpmWarningCondition::getTenantCode, tenantCode)
                .remove();
    }

    /**
     * 根据code查询预警公式
     *
     * @param codeList codeList
     * @return 预警公式
     */
    public Map<String, List<TpmWarningCondition>> findByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Maps.newConcurrentMap();
        }
        return Lists.partition(codeList, 500)
                .parallelStream()
                .flatMap(x -> {
                    LambdaQueryWrapper<TpmWarningCondition> wrapper = Wrappers.<TpmWarningCondition>lambdaQuery()
                            .in(TpmWarningCondition::getCode, x)
                            .eq(TpmWarningCondition::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
                    return this.list(wrapper).stream();
                })
                .collect(Collectors.groupingBy(TpmWarningCondition::getCode));
    }
}

