package com.biz.crm.tpm.business.warning.config.local.repository;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningConfig;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningConfigMapper;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConditionVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningReceivingObjectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;


/**
 * TPM-预警配置(TpmWarningConfig)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-03 15:44:40
 */
@Component
public class TpmWarningConfigRepository extends ServiceImpl<TpmWarningConfigMapper, TpmWarningConfig> {

    @Autowired(required = false)
    private TpmWarningConfigMapper tpmWarningConfigMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param tpmWarningConfig 实体对象
     * @return 所有数据
     */
    public Page<TpmWarningConfigVo> findByConditions(Pageable pageable, TpmWarningConfigDto tpmWarningConfig) {
        Page<TpmWarningConfigVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmWarningConfigMapper.findByConditions(page, tpmWarningConfig);
    }

    /**
     * 根据code查询预警条件
     *
     * @param code code
     */
    public List<TpmWarningConditionVo> findConditionsByCode(String code) {
        return this.tpmWarningConfigMapper.findConditionsByCode(code);
    }

    /**
     * 根据code查询预警对象
     *
     * @param code code
     */
    public List<TpmWarningReceivingObjectVo> findObjectsByCode(String code) {
        return this.tpmWarningConfigMapper.findReceivingObjectsByCode(code);
    }

    /**
     * 数据库验重 业态+业务单元+活动形式编码+销售组织+生效日期段
     * 为真验证通过
     *
     * @param dto Dto对象
     */
    public Boolean repeatValidate(TpmWarningConfigDto dto) {
        List<TpmWarningConfigVo> list = this.tpmWarningConfigMapper.repeatValidate(dto);
        return CollectionUtils.isEmpty(list);
    }

    /**
     * 根据code删除预警条件
     *
     * @param code code
     */
    public void removeByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.lambdaUpdate().eq(TpmWarningConfig::getCode, code).remove();
    }

    /**
     * 查询所有在执行的
     *
     * @return 所有在执行的预警
     */
    public List<TpmWarningConfigVo> findUnderWay() {
        List<TpmWarningConfigVo> list = this.tpmWarningConfigMapper.findUnderWay();
        if (CollectionUtils.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        return list;
    }

    public List<TpmWarningConfigDto> findRunTpmWarningMonitoring(TpmWarningConfigDto dto) {
        Date curDate = new Date();
        List<TpmWarningConfig> list = this.list(Wrappers.<TpmWarningConfig>lambdaQuery()
                .le(TpmWarningConfig::getStartDate, curDate)
                .ge(TpmWarningConfig::getEndDate, curDate)
                .eq(StringUtils.isNotBlank(dto.getCode()), TpmWarningConfig::getCode, dto.getCode())
                .eq(TpmWarningConfig::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return (List<TpmWarningConfigDto>) nebulaToolkitService.copyCollectionByWhiteList(list,TpmWarningConfig.class,TpmWarningConfigDto.class, HashSet.class, ArrayList.class);
    }
}

