package com.biz.crm.tpm.business.warning.config.local.repository;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningConfig;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoring;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningConfigMapper;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningMonitoringLogMapper;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningMonitoringMapper;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWaringMonitoringStatus;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningMonitoringVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;


/**
 * TPM-预警配置(TpmWarningConfig)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-03 15:44:40
 */
@Component
public class TpmWarningMonitoringRepository extends ServiceImpl<TpmWarningMonitoringMapper, TpmWarningMonitoring> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Value("${spring.application.name}")
    private String applicationName;

    public List<TpmWarningMonitoring> findByBusinessCodeList(String monitoringTable,List<String> businessCodeList) {
        return this.list(Wrappers.<TpmWarningMonitoring>lambdaQuery()
                .eq(TpmWarningMonitoring::getMonitoringTable,monitoringTable)
                .in(TpmWarningMonitoring::getBusinessCode,businessCodeList)
        );
    }

    public List<String> findWarningBusinessCodeList(String monitoringTable) {
        return this.list(Wrappers.<TpmWarningMonitoring>lambdaQuery()
                .eq(TpmWarningMonitoring::getMonitoringTable,monitoringTable)
                .eq(TpmWarningMonitoring::getWarningStatus, TpmWaringMonitoringStatus.WARNING.getCode())
                .select(TpmWarningMonitoring::getBusinessCode)
        ).stream().map(TpmWarningMonitoring::getBusinessCode).distinct().collect(Collectors.toList());
    }

    public List<TpmWarningMonitoringVo> findTpmWarningMonitoringList(String monitoringTable, List<String> businessCodeList) {
        List<TpmWarningMonitoring> list = this.list(Wrappers.<TpmWarningMonitoring>lambdaQuery()
                .eq(TpmWarningMonitoring::getMonitoringTable, monitoringTable)
                .in(TpmWarningMonitoring::getBusinessCode, businessCodeList)
        );
        return (List<TpmWarningMonitoringVo>) nebulaToolkitService.copyCollectionByWhiteList(list,TpmWarningMonitoring.class,TpmWarningMonitoringVo.class, HashSet.class, ArrayList.class);
    }

    public List<String> findExcludeBusinessCodeList(String monitoringTable) {
        return this.list(Wrappers.<TpmWarningMonitoring>lambdaQuery()
                .eq(TpmWarningMonitoring::getMonitoringTable,monitoringTable)
                .eq(TpmWarningMonitoring::getEnableStatus, EnableStatusEnum.DISABLE.getCode())
                .select(TpmWarningMonitoring::getBusinessCode)
        ).stream().map(TpmWarningMonitoring::getBusinessCode).collect(Collectors.toList());
    }

    public List<DynamicTaskSchedulerVo> findWarningMonitoringTaskList(DynamicTaskSchedulerDto dynamicTaskSchedulerDto) {
        dynamicTaskSchedulerDto.setAppCode(TenantUtils.getTenantCode());
        dynamicTaskSchedulerDto.setApplicationName(applicationName);
        return baseMapper.findWarningMonitoringTaskList(dynamicTaskSchedulerDto);
    }
}

