package com.biz.crm.tpm.business.warning.config.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningCondition;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningConfig;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningReceivingObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * TPM-预警配置-预警对象子表(TpmWarningReceivingObject)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-05 11:15:09
 */
@Component
public class TpmWarningReceivingObjectRepository extends ServiceImpl<TpmWarningReceivingObjectMapper, TpmWarningReceivingObject> {

    @Autowired(required = false)
    private TpmWarningReceivingObjectMapper tpmWarningReceivingObjectMapper;

    /**
     * 分页查询数据
     *
     * @param pageable                  分页对象
     * @param tpmWarningReceivingObject 实体对象
     * @return
     */
    public Page<TpmWarningReceivingObject> findByConditions(Pageable pageable, TpmWarningReceivingObject tpmWarningReceivingObject) {
        Page<TpmWarningReceivingObject> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmWarningReceivingObjectMapper.findByConditions(page, tpmWarningReceivingObject);
    }

    /**
     * 根据code查询预警范围
     */
    public List<TpmWarningReceivingObject> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmWarningReceivingObject::getCode, code)
                .eq(TpmWarningReceivingObject::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据code删除预警对象
     *
     * @param code       code
     * @param tenantCode 租户编号
     */
    public void removeByCode(String code, String tenantCode) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmWarningReceivingObject::getCode, code)
                .eq(TpmWarningReceivingObject::getTenantCode, tenantCode)
                .remove();
    }
}

