package com.biz.crm.tpm.business.warning.config.local.service;


import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningCondition;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * TPM-预警配置-条件子表(TpmWarningCondition)表服务接口
 *
 * @author duyiran
 * @since 2022-11-05 11:14:06
 */
public interface TpmWarningConditionService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param tpmWarningCondition 实体对象
   * @return
   */
  Page<TpmWarningCondition> findByConditions(Pageable pageable, TpmWarningCondition tpmWarningCondition);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  TpmWarningCondition findById(String id);
  
   /**
   * 新增数据
   * @param tpmWarningCondition 实体对象
   * @return 新增结果
   */
  TpmWarningCondition create(TpmWarningCondition tpmWarningCondition);
  
   /**
   * 修改新据
   * @param tpmWarningCondition 实体对象
   * @return 修改结果
   */
  TpmWarningCondition update(TpmWarningCondition tpmWarningCondition);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

}

