package com.biz.crm.tpm.business.warning.config.local.service;


import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TPM-预警配置-预警对象子表(TpmWarningReceivingObject)表服务接口
 *
 * @author duyiran
 * @since 2022-11-05 11:15:08
 */
public interface TpmWarningReceivingObjectService {

    /**
     * 分页查询数据
     *
     * @param pageable                  分页对象
     * @param tpmWarningReceivingObject 实体对象
     * @return
     */
    Page<TpmWarningReceivingObject> findByConditions(Pageable pageable, TpmWarningReceivingObject tpmWarningReceivingObject);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmWarningReceivingObject findById(String id);

    /**
     * 新增数据
     *
     * @param tpmWarningReceivingObject 实体对象
     * @return 新增结果
     */
    TpmWarningReceivingObject create(TpmWarningReceivingObject tpmWarningReceivingObject);

    /**
     * 修改新据
     *
     * @param tpmWarningReceivingObject 实体对象
     * @return 修改结果
     */
    TpmWarningReceivingObject update(TpmWarningReceivingObject tpmWarningReceivingObject);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

}

