package com.biz.crm.tpm.business.warning.config.local.service;

import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import org.springframework.core.Ordered;

import java.util.List;
import java.util.Map;

/**
 * 预警消息推送构建
 * @author wanghaojia
 * @date 2023/10/20 17:54
 */
public interface WarningMonitoringPushMsgStrategy extends Ordered {

    /**
     * 是否匹配逻辑
     */
    boolean matched(TpmWarningConfigDto dto);

    /**
     * 获取推送信息
     */
    List<TpmWarningMonitoringMsgPushDto> getPushMsg(TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister,
                                                    List<Map<String, Object>> warningDataList, List<TpmWarningMonitoringLog> warningMonitoringLogList,
                                                    List<TpmWarningReceivingObject> receivingObjects);

}
