package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningConfigMapper;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigExportsDto;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigExportsVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author duyiran
 * @create 2022-11-05 17:48
 */
@Component
public class TpmWarningConfigExportsProcess implements ExportProcess<TpmWarningConfigExportsVo> {

    @Autowired(required = false)
    private TpmWarningConfigMapper tpmWarningConfigMapper;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    /**
     * 获取当前任务需要导出数据总记录数(用于拆分子任务)
     *
     * @param params 自定义参数
     * @return
     */
    @Override
    public Integer getTotal(Map<String, Object> params) {
        TpmWarningConfigExportsDto dto = this.convertParams(params);
        Integer total = tpmWarningConfigMapper.getExportTotal(dto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    /**
     * 数据处理（最终处理）
     *
     * @param vo     导出任务处理器实体信息
     * @param params 扩展参数
     * @return
     */
    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        TpmWarningConfigExportsDto dto = this.convertParams(params);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<TpmWarningConfigExportsVo> data = tpmWarningConfigMapper.findData(dto);
        return JSON.parseArray(JSON.toJSONString(data));
    }

    /**
     * 获取对象转换实体
     *
     * @return
     */
    @Override
    public Class<TpmWarningConfigExportsVo> findCrmExcelVoClass() {
        return TpmWarningConfigExportsVo.class;
    }

    /**
     * 导出业务编码
     *
     * @return
     */
    @Override
    public String getBusinessCode() {
        return "TPM_WARNING_CONFIG_EXPORT";
    }

    /**
     * 导出业务名称
     *
     * @return
     */
    @Override
    public String getBusinessName() {
        return "TPM预警配置导出";
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private TpmWarningConfigExportsDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), TpmWarningConfigExportsDto.class);
    }
}
