package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.third.system.alibaba.dingtalk.sdk.service.DingTalkService;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningReceivingObjectRepository;
import com.biz.crm.tpm.business.warning.config.local.service.WarningMonitoringPushMsgStrategy;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 监控表预警
 * @author wanghaojia
 * @date 2023/6/14 16:27
 */
@Slf4j
@Service
public class TpmWarningMonitoringAsyncService {

    @Autowired(required = false)
    private DingTalkService dingTalkService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private TpmWarningReceivingObjectRepository tpmWarningReceivingObjectRepository;

    @Autowired(required = false)
    private List<WarningMonitoringPushMsgStrategy> pushMsgStrategyList;

    @Async
    public void pushMsg(UserIdentity loginUser, TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister,
                        List<Map<String, Object>> warningDataList, List<TpmWarningMonitoringLog> warningMonitoringLogList){
        loginUserService.refreshAuthentication(loginUser);
        List<TpmWarningReceivingObject> receivingObjects = tpmWarningReceivingObjectRepository.findByCode(dto.getCode());
        WarningMonitoringPushMsgStrategy msgStrategy = null;
        for (WarningMonitoringPushMsgStrategy strategy : pushMsgStrategyList) {
            if (strategy.matched(dto)){
                msgStrategy = strategy;
                break;
            }
        }
        if (null == msgStrategy){
            return;
        }
        List<TpmWarningMonitoringMsgPushDto> pushMsgList = msgStrategy.getPushMsg(dto, variableRegister, warningDataList, warningMonitoringLogList, receivingObjects);
        if (CollectionUtils.isEmpty(pushMsgList)){
            return;
        }
        log.info("预警["+dto.getCode()+"]推送钉钉:"+ JSONObject.toJSONString(pushMsgList));


        List<TpmWarningMonitoringVariable> variableList = variableRegister.allVariableList();
        //按字段长度从大到小排序，这样就不会出现替换错误的情况
        variableList.sort(Comparator.comparing((TpmWarningMonitoringVariable item) -> item.getVariableField().length()).reversed());

        for (TpmWarningMonitoringMsgPushDto tpmWarningMonitoringMsgPushDto : pushMsgList) {
            if (CollectionUtils.isEmpty(tpmWarningMonitoringMsgPushDto.getUserNameList())){
                continue;
            }

            String pushContent = replacePushContentVariable(dto, variableList,tpmWarningMonitoringMsgPushDto.getVariableMap());
            if (StringUtils.isEmpty(pushContent)){
                continue;
            }
            //没有区分类型，直接推送钉钉吧
            dingTalkService.sendTextMsgByUserIdList(tpmWarningMonitoringMsgPushDto.getUserNameList(),pushContent);
        }
    }

    public String replacePushContentVariable(TpmWarningConfigDto dto,List<TpmWarningMonitoringVariable> variableList,Map<String, Object> variableMap){
        String computeFormula = dto.getPushContentFormula();
        for (TpmWarningMonitoringVariable tpmWarningMonitoringVariable : variableList) {
            String valueStr = "";
            if (variableMap.containsKey(tpmWarningMonitoringVariable.getVariableField())){
                Object valueObj = Optional.ofNullable(variableMap.get(tpmWarningMonitoringVariable.getVariableField())).orElse("");
                valueStr = valueObj.toString();
            }
            computeFormula = computeFormula.replace(tpmWarningMonitoringVariable.getVariableField(),valueStr);
        }
        return computeFormula;
    }

}
