package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningMonitoringRepository;
import com.biz.crm.tpm.business.warning.config.local.service.TpmWarningMonitoringService;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningMonitoringSdkService;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningMonitoringVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/6/16 09:58
 */
@Service
public class TpmWarningMonitoringSdkServiceImpl implements TpmWarningMonitoringSdkService {

    @Autowired(required = false)
    private TpmWarningMonitoringRepository tpmWarningMonitoringRepository;

    @Override
    public List<String> findWarningBusinessCodeList(String monitoringTable) {
        return tpmWarningMonitoringRepository.findWarningBusinessCodeList(monitoringTable);
    }

    @Override
    public List<TpmWarningMonitoringVo> findTpmWarningMonitoringList(String monitoringTable, List<String> businessCodeList) {
        return tpmWarningMonitoringRepository.findTpmWarningMonitoringList(monitoringTable,businessCodeList);
    }

    @Override
    public List<String> findExcludeBusinessCodeList(String monitoringTable) {
        return tpmWarningMonitoringRepository.findExcludeBusinessCodeList(monitoringTable);
    }


}
