package com.biz.crm.tpm.business.warning.config.local.service.internal.msgbuilder;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.service.WarningMonitoringPushMsgStrategy;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningReceivingObjectTypeEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 默认推送信息策略
 * @author wanghaojia
 * @date 2023/10/20 17:56
 */
@Component
public class DefaultWarningMonitoringPushMsgStrategy implements WarningMonitoringPushMsgStrategy {


    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private UserVoService userVoService;

    private static final String TPM_WARING_MONITORING_TABLE = "tpm_waring_monitoring_table";

    @Override
    public int getOrder(){
        //最后一个工作
        return LOWEST_PRECEDENCE;
    }

    @Override
    public boolean matched(TpmWarningConfigDto dto){
        return true;
    }

    @Override
    public List<TpmWarningMonitoringMsgPushDto> getPushMsg(TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister, List<Map<String, Object>> warningDataList, List<TpmWarningMonitoringLog> warningMonitoringLogList, List<TpmWarningReceivingObject> receivingObjects) {
        TpmWarningMonitoringMsgPushDto tpmWarningMonitoringMsgPushDto = new TpmWarningMonitoringMsgPushDto();
        Map<String,Object> variableMap = Maps.newHashMap();
        variableMap.put("warningMsg",defaultWarningMsg(dto,warningDataList.size()));
        tpmWarningMonitoringMsgPushDto.setVariableMap(variableMap);
        tpmWarningMonitoringMsgPushDto.setUserNameList(getPushUserNameList(receivingObjects));
        return Lists.newArrayList(tpmWarningMonitoringMsgPushDto);
    }

    public List<String> getPushUserNameList(List<TpmWarningReceivingObject> receivingObjects){
        //只处理职位包含的数据吧
        List<String> positionCodeList = receivingObjects.stream().filter(item -> {
            return TpmWarningReceivingObjectTypeEnum.POSITION.getCode().equals(item.getWarningReceivingObjectType())
                    && BooleanEnum.TRUE.getCapital().equals(item.getIsContains());
        }).map(TpmWarningReceivingObject::getSubCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positionCodeList)){
            return Lists.newArrayList();
        }
        List<UserVo> userVos = userVoService.findByPositionCodeList(positionCodeList);
        if (CollectionUtils.isEmpty(userVos)){
            return Lists.newArrayList();
        }
        return userVos.stream().map(UserVo::getUserName).collect(Collectors.toList());
    }

    public String defaultWarningMsg(TpmWarningConfigDto dto, long warningDataCount) {
        List<TpmWarningConditionDto> conditionDtoList = dto.getConditionList();
        StringBuilder warningMsgBuilder =  new StringBuilder("出现");
        warningMsgBuilder.append(warningDataCount).append("条异常，");
        for (TpmWarningConditionDto tpmWarningConditionDto : conditionDtoList) {
            if (null != tpmWarningConditionDto.getWarningCount() && tpmWarningConditionDto.getWarningCount() > 0){
                warningMsgBuilder.append(tpmWarningConditionDto.getFormulaName()).append("[").append(tpmWarningConditionDto.getWarningCount()).append("]条，");
            }
        }
        return warningMsgBuilder.toString();
    }

}
