package com.biz.crm.tpm.business.warning.config.local.service.internal.msgbuilder;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.service.WarningMonitoringPushMsgStrategy;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningReceivingObjectTypeEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 垂直推送信息策略逻辑
 *
 * @author wanghaojia
 * @date 2023/10/20 17:56
 */
@Slf4j
@Component
public class VerticalWarningMonitoringPushMsgStrategy implements WarningMonitoringPushMsgStrategy {

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public boolean matched(TpmWarningConfigDto dto) {
        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return true;
        }
        return false;
    }

    @Override
    public List<TpmWarningMonitoringMsgPushDto> getPushMsg(TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister, List<Map<String, Object>> warningDataList,
                                                           List<TpmWarningMonitoringLog> warningMonitoringLogList, List<TpmWarningReceivingObject> receivingObjects) {
        if (!(variableRegister instanceof AbstractTpmWarningMonitoringVariableAndPushGroupRegister)) {
            return null;
        }
        AbstractTpmWarningMonitoringVariableAndPushGroupRegister variableAndPushGroupRegister = (AbstractTpmWarningMonitoringVariableAndPushGroupRegister) variableRegister;
        //先汇总数据
        List<Map<String, Object>> groupDataList = variableAndPushGroupRegister.groupList(dto, warningDataList);
        log.error("预警配置[" + dto.getCode() + "]汇总数据条数:" + groupDataList.size());
        List<TpmWarningMonitoringMsgPushDto> list = Lists.newArrayList();
        for (Map<String, Object> objectMap : groupDataList) {
            TpmWarningMonitoringMsgPushDto tpmWarningMonitoringMsgPushDto = new TpmWarningMonitoringMsgPushDto();
            objectMap.put("warningMsg", defaultWarningMsg(dto, objectMap, variableAndPushGroupRegister));
            tpmWarningMonitoringMsgPushDto.setVariableMap(objectMap);

            //找推送人的逻辑
            tpmWarningMonitoringMsgPushDto.setUserNameList(getPushUserName(dto, objectMap, variableAndPushGroupRegister, receivingObjects));
            list.add(tpmWarningMonitoringMsgPushDto);
        }
        return list;
    }

    private List<String> getPushUserName(TpmWarningConfigDto dto, Map<String, Object> objectMap,
                                         AbstractTpmWarningMonitoringVariableAndPushGroupRegister variableRegister, List<TpmWarningReceivingObject> receivingObjects) {
        String pushDimension = dto.getPushDimension();
        String[] split = pushDimension.split(",");
        receivingObjects = receivingObjects.stream().filter(item -> TpmWarningReceivingObjectTypeEnum.PUSH_DIMENSION.getCode().equals(item.getWarningReceivingObjectType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(receivingObjects)) {
            return Lists.newArrayList();
        }

        Map<String, String> dimensionMap = Maps.newHashMap();
        for (String dimension : split) {
            TpmWarningDimensionEnum dimensionEnum = TpmWarningDimensionEnum.findByCode(dimension);
            if (null == dimensionEnum) {
                continue;
            }
            //维度对应的编码键
            String dimensionCodeKey = variableRegister.getDimensionCodeKey(dimensionEnum);
            Object dimensionValue = objectMap.get(dimensionCodeKey);
            if (null == dimensionValue || StringUtils.isEmpty(dimensionValue.toString())) {
                continue;
            }
            dimensionMap.put(dimension, dimensionValue.toString());
        }

        List<String> userNameList = Lists.newArrayList();
        for (TpmWarningReceivingObject receivingObject : receivingObjects) {
            if (StringUtils.isEmpty(receivingObject.getUserName())) {
                continue;
            }
            boolean hasEquals = false;
            //3个维度都校验下
            if (StringUtils.isNotEmpty(receivingObject.getRegionCode())) {
                if (!receivingObject.getRegionCode().equals(dimensionMap.get(TpmWarningDimensionEnum.REGION.getCode()))
                        && !receivingObject.getRegionName().equals(dimensionMap.get(TpmWarningDimensionEnum.REGION.getCode()))) {
                    continue;
                }
                hasEquals = true;
            }
            if (StringUtils.isNotEmpty(receivingObject.getCustomerRetailerCode())) {
                if (!receivingObject.getCustomerRetailerCode().equals(dimensionMap.get(TpmWarningDimensionEnum.SYSTEM.getCode()))) {
                    continue;
                }
                hasEquals = true;
            }
            if (StringUtils.isNotEmpty(receivingObject.getCustomerCode())) {
                if (!receivingObject.getCustomerCode().equals(dimensionMap.get(TpmWarningDimensionEnum.CUSTOMER.getCode()))) {
                    continue;
                }
                hasEquals = true;
            }
            if (hasEquals) {
                userNameList.add(receivingObject.getUserName());
            }
        }

        return userNameList;
    }

    /**
     * 默认预警信息
     */
    public String defaultWarningMsg(TpmWarningConfigDto dto, Map<String, Object> objectMap, AbstractTpmWarningMonitoringVariableAndPushGroupRegister variableRegister) {
        long warningDataCount = Long.parseLong(objectMap.get("warning_count").toString());

        List<TpmWarningConditionDto> conditionDtoList = dto.getConditionList();
        StringBuilder warningMsgBuilder = new StringBuilder("出现");
        warningMsgBuilder.append(warningDataCount).append("条异常，");

        List<String> dimensionCodeKeyList = variableRegister.getDimensionCodeKeyList(dto);

        for (TpmWarningConditionDto tpmWarningConditionDto : conditionDtoList) {
            List<Map<String, Object>> warningDataList = tpmWarningConditionDto.getWarningDataList();
            if (CollectionUtils.isEmpty(warningDataList)) {
                continue;
            }
            List<Map<String, Object>> conditionWarningDataList = warningDataList.stream().filter(item -> {
                for (String dimensionCodeKey : dimensionCodeKeyList) {
                    if (!equalsNullDeal(item.get(dimensionCodeKey),objectMap.get(dimensionCodeKey))) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
            if (conditionWarningDataList.size() > 0) {
                warningMsgBuilder.append(tpmWarningConditionDto.getFormulaName()).append("[").append(conditionWarningDataList.size()).append("]条，");
            }
        }
        return warningMsgBuilder.toString();
    }

    private boolean equalsNullDeal(Object a,Object b){
        if (null == a && null == b){
            return true;
        }else if (null != a && null != b && a.equals(b)){
            return true;
        }
        return false;
    }

}
