package com.biz.crm.tpm.business.warning.config.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author duyiran
 * @create 2022-11-05 17:49
 */
@Data
@ApiModel(value = "TpmWarningConfig", description = "预警配置")
public class TpmWarningConfigExportsDto implements Serializable, Cloneable{

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty(name = "enableStatus", notes = "数据业务状态（启用状态）", value = "数据业务状态（启用状态）")
    private String enableStatus;

    /**
     * 偏移量
     */
    @ApiModelProperty(name = "offset", notes = "偏移量", value = "偏移量")
    private Integer offset;

    /**
     * limit
     */
    @ApiModelProperty(name = "limit", notes = "limit", value = "limit")
    private Integer limit;

    /**
     * 预警规则编码[数据字典:tpm_warning_config_status]
     */
    @ApiModelProperty(name = "预警状态[数据字典:tpm_warning_config_status]", notes = "")
    private String status;

    @ApiModelProperty(name = "预警规则编码", notes = "")
    private String code;

    /**
     * 预警规则名称
     */
    @ApiModelProperty(name = "预警规则名称", notes = "")
    private String name;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "")
    private String salesOrgName;

    /**
     * 活动形式Code
     */
    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    /**
     * 预警方式[数据字典:tpm_warning_mode]
     */
    @ApiModelProperty(name = "预警方式[数据字典:tpm_warning_mode]", notes = "预警方式[数据字典:tpm_warning_mode]")
    private String warningMode;

    /**
     * 预警开始日期
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 预警结束日期
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
}
