package com.biz.crm.tpm.business.warning.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 预警配置-预警对象dto
 *
 * @author duyiran
 * @create 2022-11-04 16:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class TpmWarningReceivingObjectDto extends TenantFlagOpDto {

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    private String code;

    /**
     * 组织/职位编码
     */
    @ApiModelProperty(name = "组织/职位编码", notes = "组织/职位编码")
    private String subCode;

    /**
     * 组织/职位名称
     */
    @ApiModelProperty(name = "组织/职位名称", notes = "组织/职位名称")
    private String subName;

    /**
     * 预警对象类型[数据字典:tpm_warning_receiving_object_type]
     */
    @ApiModelProperty(name = "预警对象类型[数据字典:tpm_warning_receiving_object_type]", notes = "预警对象类型[数据字典:tpm_warning_receiving_object_type]")
    private String warningReceivingObjectType;

    /**
     * 是否包含[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "是否包含[数据字典:yesOrNo]", notes = "是否包含[数据字典:yesOrNo]")
    private String isContains;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "区域编码")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "区域名称")
    private String regionName;


    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    private String customerRetailerName;


    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 用户账号
     */
    @ApiModelProperty(name = "用户账号", notes = "用户账号")
    private String userName;

    /**
     * 用户名
     */
    @ApiModelProperty(name = "用户名", notes = "用户名")
    private String fullName;

}
