package com.biz.crm.tpm.business.warning.config.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 预警配置状态[数据字典:tpm_warning_config_status]
 *
 * @author duyiran
 * @create 2022-11-03 20:00
 */
public enum TpmWarningConfigStatusEnum {

    NOTSTARTED("notStarted","待执行"),
    UNDERWAY("underWay","执行中"),
    HASENDED("hasEnded","已结束");

    TpmWarningConfigStatusEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static TpmWarningConfigStatusEnum findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(TpmWarningConfigStatusEnum type : values()){
            if(StringUtils.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
