package com.biz.crm.tpm.business.warning.config.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 预警推送维度
 * @author wanghaojia
 * @date 2023/10/23 13:46
 */
@Getter
public enum TpmWarningDimensionEnum {


    REGION("region","区域"),
    SYSTEM("system","零售商"),
    CUSTOMER("customer","客户"),
    ;

    TpmWarningDimensionEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static TpmWarningDimensionEnum findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(TpmWarningDimensionEnum dimensionEnum : values()){
            if(StringUtils.equals(dimensionEnum.getCode(),code)){
                return dimensionEnum;
            }
        }
        return null;
    }

}
