package com.biz.crm.tpm.business.warning.config.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 预警配置状态[数据字典:tpm_warning_config_status]
 *
 * @author duyiran
 * @create 2022-11-03 20:00
 */
public enum TpmWarningLevelEnum {

    COMMON("common","一般"),
    SERIOUS("serious","严重");

    TpmWarningLevelEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static TpmWarningLevelEnum findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(TpmWarningLevelEnum type : values()){
            if(StringUtils.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
